//===-- lldb-riscv-register-enums.h -----------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLDB_SOURCE_PLUGINS_PROCESS_UTILITY_LLDB_RISCV_REGISTER_ENUMS_H
#define LLDB_SOURCE_PLUGINS_PROCESS_UTILITY_LLDB_RISCV_REGISTER_ENUMS_H

// LLDB register codes (e.g. RegisterKind == eRegisterKindLLDB)

// Internal codes for all riscv registers.
enum {
  // The same order as user_regs_struct in <asm/ptrace.h>
  // note: these enum values are used as byte_offset
  gpr_first_riscv = 0,
  gpr_pc_riscv = gpr_first_riscv,
  gpr_x1_riscv,
  gpr_x2_riscv,
  gpr_x3_riscv,
  gpr_x4_riscv,
  gpr_x5_riscv,
  gpr_x6_riscv,
  gpr_x7_riscv,
  gpr_x8_riscv,
  gpr_x9_riscv,
  gpr_x10_riscv,
  gpr_x11_riscv,
  gpr_x12_riscv,
  gpr_x13_riscv,
  gpr_x14_riscv,
  gpr_x15_riscv,
  gpr_x16_riscv,
  gpr_x17_riscv,
  gpr_x18_riscv,
  gpr_x19_riscv,
  gpr_x20_riscv,
  gpr_x21_riscv,
  gpr_x22_riscv,
  gpr_x23_riscv,
  gpr_x24_riscv,
  gpr_x25_riscv,
  gpr_x26_riscv,
  gpr_x27_riscv,
  gpr_x28_riscv,
  gpr_x29_riscv,
  gpr_x30_riscv,
  gpr_x31_riscv,
  gpr_x0_riscv,
  gpr_zero_riscv = gpr_x0_riscv,
  gpr_ra_riscv = gpr_x1_riscv,
  gpr_sp_riscv = gpr_x2_riscv,
  gpr_gp_riscv = gpr_x3_riscv,
  gpr_tp_riscv = gpr_x4_riscv,
  gpr_t0_riscv = gpr_x5_riscv,
  gpr_t1_riscv = gpr_x6_riscv,
  gpr_t2_riscv = gpr_x7_riscv,
  gpr_fp_riscv = gpr_x8_riscv,
  gpr_s1_riscv = gpr_x9_riscv,
  gpr_a0_riscv = gpr_x10_riscv,
  gpr_a1_riscv = gpr_x11_riscv,
  gpr_a2_riscv = gpr_x12_riscv,
  gpr_a3_riscv = gpr_x13_riscv,
  gpr_a4_riscv = gpr_x14_riscv,
  gpr_a5_riscv = gpr_x15_riscv,
  gpr_a6_riscv = gpr_x16_riscv,
  gpr_a7_riscv = gpr_x17_riscv,
  gpr_s2_riscv = gpr_x18_riscv,
  gpr_s3_riscv = gpr_x19_riscv,
  gpr_s4_riscv = gpr_x20_riscv,
  gpr_s5_riscv = gpr_x21_riscv,
  gpr_s6_riscv = gpr_x22_riscv,
  gpr_s7_riscv = gpr_x23_riscv,
  gpr_s8_riscv = gpr_x24_riscv,
  gpr_s9_riscv = gpr_x25_riscv,
  gpr_s10_riscv = gpr_x26_riscv,
  gpr_s11_riscv = gpr_x27_riscv,
  gpr_t3_riscv = gpr_x28_riscv,
  gpr_t4_riscv = gpr_x29_riscv,
  gpr_t5_riscv = gpr_x30_riscv,
  gpr_t6_riscv = gpr_x31_riscv,
  gpr_last_riscv = gpr_x0_riscv,

  fpr_first_riscv = 33,
  fpr_f0_riscv = fpr_first_riscv,
  fpr_f1_riscv,
  fpr_f2_riscv,
  fpr_f3_riscv,
  fpr_f4_riscv,
  fpr_f5_riscv,
  fpr_f6_riscv,
  fpr_f7_riscv,
  fpr_f8_riscv,
  fpr_f9_riscv,
  fpr_f10_riscv,
  fpr_f11_riscv,
  fpr_f12_riscv,
  fpr_f13_riscv,
  fpr_f14_riscv,
  fpr_f15_riscv,
  fpr_f16_riscv,
  fpr_f17_riscv,
  fpr_f18_riscv,
  fpr_f19_riscv,
  fpr_f20_riscv,
  fpr_f21_riscv,
  fpr_f22_riscv,
  fpr_f23_riscv,
  fpr_f24_riscv,
  fpr_f25_riscv,
  fpr_f26_riscv,
  fpr_f27_riscv,
  fpr_f28_riscv,
  fpr_f29_riscv,
  fpr_f30_riscv,
  fpr_f31_riscv,

  fpr_fcsr_riscv,
  fpr_ft0_riscv = fpr_f0_riscv,
  fpr_ft1_riscv = fpr_f1_riscv,
  fpr_ft2_riscv = fpr_f2_riscv,
  fpr_ft3_riscv = fpr_f3_riscv,
  fpr_ft4_riscv = fpr_f4_riscv,
  fpr_ft5_riscv = fpr_f5_riscv,
  fpr_ft6_riscv = fpr_f6_riscv,
  fpr_ft7_riscv = fpr_f7_riscv,
  fpr_fs0_riscv = fpr_f8_riscv,
  fpr_fs1_riscv = fpr_f9_riscv,
  fpr_fa0_riscv = fpr_f10_riscv,
  fpr_fa1_riscv = fpr_f11_riscv,
  fpr_fa2_riscv = fpr_f12_riscv,
  fpr_fa3_riscv = fpr_f13_riscv,
  fpr_fa4_riscv = fpr_f14_riscv,
  fpr_fa5_riscv = fpr_f15_riscv,
  fpr_fa6_riscv = fpr_f16_riscv,
  fpr_fa7_riscv = fpr_f17_riscv,
  fpr_fs2_riscv = fpr_f18_riscv,
  fpr_fs3_riscv = fpr_f19_riscv,
  fpr_fs4_riscv = fpr_f20_riscv,
  fpr_fs5_riscv = fpr_f21_riscv,
  fpr_fs6_riscv = fpr_f22_riscv,
  fpr_fs7_riscv = fpr_f23_riscv,
  fpr_fs8_riscv = fpr_f24_riscv,
  fpr_fs9_riscv = fpr_f25_riscv,
  fpr_fs10_riscv = fpr_f26_riscv,
  fpr_fs11_riscv = fpr_f27_riscv,
  fpr_ft8_riscv = fpr_f28_riscv,
  fpr_ft9_riscv = fpr_f29_riscv,
  fpr_ft10_riscv = fpr_f30_riscv,
  fpr_ft11_riscv = fpr_f31_riscv,
  fpr_last_riscv = fpr_fcsr_riscv,

  vpr_first_riscv = 66,
  vpr_v0_riscv = vpr_first_riscv,
  vpr_v1_riscv,
  vpr_v2_riscv,
  vpr_v3_riscv,
  vpr_v4_riscv,
  vpr_v5_riscv,
  vpr_v6_riscv,
  vpr_v7_riscv,
  vpr_v8_riscv,
  vpr_v9_riscv,
  vpr_v10_riscv,
  vpr_v11_riscv,
  vpr_v12_riscv,
  vpr_v13_riscv,
  vpr_v14_riscv,
  vpr_v15_riscv,
  vpr_v16_riscv,
  vpr_v17_riscv,
  vpr_v18_riscv,
  vpr_v19_riscv,
  vpr_v20_riscv,
  vpr_v21_riscv,
  vpr_v22_riscv,
  vpr_v23_riscv,
  vpr_v24_riscv,
  vpr_v25_riscv,
  vpr_v26_riscv,
  vpr_v27_riscv,
  vpr_v28_riscv,
  vpr_v29_riscv,
  vpr_v30_riscv,
  vpr_v31_riscv,
  vpr_last_riscv = vpr_v31_riscv,

  k_num_registers_riscv
};

#endif // LLDB_SOURCE_PLUGINS_PROCESS_UTILITY_LLDB_RISCV_REGISTER_ENUMS_H
