/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.user.GraphicsPreferences;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.tecEdit.LibToTech;
import com.sun.electric.tool.user.tecEdit.TechConversionResult;
import com.sun.electric.tool.user.tecEdit.TechToLib;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.util.math.MutableBoolean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TechnologyEditTest
extends AbstractTest {
    EditingPreferences ep = UserInterfaceMain.getEditingPreferences();
    GraphicsPreferences gp = UserInterfaceMain.getGraphicsPreferences();

    public TechnologyEditTest(String testName) {
        super(testName);
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new TechnologyEditTest("BICMOS"));
        list.add(new TechnologyEditTest("CMOS"));
        list.add(new TechnologyEditTest("MOCMOS"));
        list.add(new TechnologyEditTest("MOCMOSOLD"));
        list.add(new TechnologyEditTest("MOCMOSSUB"));
        list.add(new TechnologyEditTest("NMOS"));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/Database/output/";
    }

    public Boolean BICMOS() {
        return this.runTest("bicmos");
    }

    public Boolean CMOS() {
        return this.runTest("cmos");
    }

    public Boolean MOCMOS() {
        return this.runTest("mocmos");
    }

    public Boolean MOCMOSOLD() {
        return this.runTest("mocmosold");
    }

    public Boolean MOCMOSSUB() {
        return this.runTest("mocmossub");
    }

    public Boolean NMOS() {
        return this.runTest("nmos");
    }

    private Boolean runTest(String techName) {
        String trueRootPath = TechnologyEditTest.getValidRootPath(this.getRegressionPath(), "/tools/Database/", "");
        String outputDir = trueRootPath + "output/";
        TechnologyEditTest.ensureOutputDirectory(outputDir);
        MessagesStream.getMessagesStream().save(outputDir + techName + ".log");
        ArrayList<String> ignoreNodes = new ArrayList<String>();
        HashSet<String> ignoreNodeSize = new HashSet<String>();
        HashSet<String> ignoreTransistorFactors = new HashSet<String>();
        if (techName.equals("mocmos")) {
            Map<Setting, Object> originalContext = EDatabase.currentDatabase().getSettings();
            Integer initialTechRules = (Integer)originalContext.get(Technology.getMocmosTechnology().getSetting("MOCMOS Rule Set"));
            if (initialTechRules != 1) {
                System.out.println("ERROR: Cannot test mocmos technology editing unless rules are set to Submicron");
                return Boolean.FALSE;
            }
            ignoreNodes.add("P-Transistor-Scalable");
            ignoreNodes.add("N-Transistor-Scalable");
            ignoreNodeSize.add("Metal-1-Metal-2-Con");
            ignoreNodeSize.add("Metal-2-Metal-3-Con");
            ignoreNodeSize.add("Metal-3-Metal-4-Con");
            ignoreNodeSize.add("Metal-4-Metal-5-Con");
            ignoreNodeSize.add("Metal-5-Metal-6-Con");
            ignoreNodeSize.add("Metal-1-P-Well-Con");
            ignoreNodeSize.add("Metal-1-N-Well-Con");
            ignoreTransistorFactors.add("P-Transistor");
            ignoreTransistorFactors.add("Thick-P-Transistor");
            ignoreTransistorFactors.add("N-Transistor");
            ignoreTransistorFactors.add("Thick-N-Transistor");
        } else if (techName.equals("bicmos")) {
            ignoreNodes.add("NPN1_transistor");
            ignoreNodes.add("NPN2_transistor");
        }
        boolean good = true;
        try {
            Technology tech = Technology.findTechnology(techName);
            Library techLib = TechToLib.makeLibFromTech(tech, this.ep, this.gp);
            if (techLib == null) {
                System.out.println("ERROR: Failed to create library for " + tech.getTechName() + " technology");
                return Boolean.FALSE;
            }
            for (String ignoreName : ignoreNodes) {
                Cell ignore = techLib.findNodeProto("node-" + ignoreName + "{lay}");
                if (ignore == null) continue;
                ignore.kill();
            }
            LibToTech ltt = new LibToTech();
            TechConversionResult tcr = new TechConversionResult();
            Technology libTech = ltt.makeTech(techLib, techName + "NEW", null, tcr, this.ep);
            if (libTech == null || tcr.failed()) {
                System.out.println("ERROR: " + tcr.getErrorMessage());
                System.out.println("Failed to create technology from library");
                return Boolean.FALSE;
            }
            good = this.compareTechnologies(tech, libTech, ignoreNodes, ignoreNodeSize, ignoreTransistorFactors, this.ep);
        }
        catch (Exception e) {
            e.printStackTrace();
            good = false;
        }
        return good;
    }

    private boolean compareTechnologies(Technology tech1, Technology tech2, List<String> ignoreNodes, Set<String> ignoreNodeSize, Set<String> ignoreTransistorFactors, EditingPreferences ep) {
        String tech1Name = "technology " + tech1.getTechName();
        String tech2Name = "technology " + tech2.getTechName();
        MutableBoolean mGood = new MutableBoolean(true);
        this.doTest(tech1.getScaleSetting().getFactoryValue(), tech2.getScaleSetting().getFactoryValue(), mGood, null, "scale", tech1Name, tech2Name);
        this.doTest(tech1.getNumMetalsSetting().getFactoryValue(), tech2.getNumMetalsSetting().getFactoryValue(), mGood, null, "num-metals", tech1Name, tech2Name);
        this.doTest(tech1.getTechDesc(), tech2.getTechDesc(), mGood, null, "description", tech1Name, tech2Name);
        this.doTest(tech1.getMinResistanceSetting().getFactoryValue(), tech2.getMinResistanceSetting().getFactoryValue(), mGood, null, "min-resistance", tech1Name, tech2Name);
        this.doTest(tech1.getMinCapacitanceSetting().getFactoryValue(), tech2.getMinCapacitanceSetting().getFactoryValue(), mGood, null, "min-capacitance", tech1Name, tech2Name);
        this.doTest(tech1.getMaxSeriesResistanceSetting().getFactoryValue(), tech2.getMaxSeriesResistanceSetting().getFactoryValue(), mGood, null, "min-series-resistance", tech1Name, tech2Name);
        this.doTest(tech1.getGateLengthSubtractionSetting().getFactoryValue(), tech2.getGateLengthSubtractionSetting().getFactoryValue(), mGood, null, "gate-shrinkage", tech1Name, tech2Name);
        this.doTest(tech1.getGateIncludedSetting().getFactoryValue(), tech2.getGateIncludedSetting().getFactoryValue(), mGood, null, "gate-inclusion", tech1Name, tech2Name);
        this.doTest(tech1.isGroundNetIncluded(), tech2.isGroundNetIncluded(), mGood, null, "parasitics-includes-ground", tech1Name, tech2Name);
        int maxLayers = Math.max(tech1.getNumLayers(), tech2.getNumLayers());
        for (int i = 0; i < maxLayers; ++i) {
            if (i >= tech1.getNumLayers()) {
                System.out.println("ERROR: Layer " + tech2.getLayer(i).getName() + " exists in technology " + tech2.getTechName() + " but not in technology " + tech1.getTechName());
                mGood.setValue(false);
                continue;
            }
            if (i >= tech2.getNumLayers()) {
                System.out.println("ERROR: Layer " + tech1.getLayer(i).getName() + " exists in technology " + tech1.getTechName() + " but not in technology " + tech2.getTechName());
                mGood.setValue(false);
                continue;
            }
            Layer layer1 = tech1.getLayer(i);
            Layer layer2 = tech2.getLayer(i);
            this.doTest(layer1.getName(), layer2.getName(), mGood, "Layer " + i, "name", tech1Name, tech2Name);
            String layerName = "Layer " + layer1.getName();
            this.doTest((Object)layer1.getFunction(), (Object)layer2.getFunction(), mGood, layerName, "function", tech1Name, tech2Name);
            this.doTest(Layer.Function.getExtraName(layer1.getFunctionExtras()), Layer.Function.getExtraName(layer2.getFunctionExtras()), mGood, layerName, "function-extra", tech1Name, tech2Name);
            this.doTest(layer1.getCIFLayer(), layer2.getCIFLayer(), mGood, layerName, "CIF-layer", tech1Name, tech2Name);
            this.doTest(layer1.getDXFLayer(), layer2.getDXFLayer(), mGood, layerName, "DXF-layer", tech1Name, tech2Name);
            this.doTest(layer1.getResistance(), layer2.getResistance(), mGood, layerName, "resistance", tech1Name, tech2Name);
            this.doTest(layer1.getCapacitance(), layer2.getCapacitance(), mGood, layerName, "capacitance", tech1Name, tech2Name);
            this.doTest(layer1.getEdgeCapacitance(), layer2.getEdgeCapacitance(), mGood, layerName, "edge-capacitance", tech1Name, tech2Name);
            EGraphics gra1 = layer1.getFactoryGraphics();
            EGraphics gra2 = layer2.getFactoryGraphics();
            this.doTest(gra1.getColor(), gra2.getColor(), mGood, layerName, "color", tech1Name, tech2Name);
            this.doTest(gra1.getForeground(), gra2.getForeground(), mGood, layerName, "foreground", tech1Name, tech2Name);
            this.doTest(gra1.getOpacity(), gra2.getOpacity(), mGood, layerName, "opacity", tech1Name, tech2Name);
            this.doTest((Object)gra1.getOutlined(), (Object)gra2.getOutlined(), mGood, layerName, "outline", tech1Name, tech2Name);
            this.doTest(gra1.getTransparentLayer(), gra2.getTransparentLayer(), mGood, layerName, "transparency", tech1Name, tech2Name);
            boolean patSame = true;
            for (int j = 0; j < 16; ++j) {
                if (gra1.getPattern()[j] == gra2.getPattern()[j]) continue;
                patSame = false;
            }
            if (!patSame) {
                System.out.println("ERROR: " + layerName + " has pattern " + gra1.getPattern() + " in " + tech1Name + " but pattern " + gra2.getPattern() + " in " + tech2Name);
                mGood.setValue(false);
            }
            this.doTest(gra1.isPatternedOnDisplay(), gra2.isPatternedOnDisplay(), mGood, layerName, "display-pattern", tech1Name, tech2Name);
            this.doTest(gra1.isPatternedOnPrinter(), gra2.isPatternedOnPrinter(), mGood, layerName, "printer-pattern", tech1Name, tech2Name);
            String pureName1 = "";
            PrimitiveNode primitiveNode = layer1.getPureLayerNode();
            if (primitiveNode != null) {
                pureName1 = primitiveNode.getName();
            }
            String pureName2 = "";
            PrimitiveNode pure2 = layer2.getPureLayerNode();
            if (pure2 != null) {
                pureName2 = pure2.getName();
            }
            this.doTest(pureName1, pureName2, mGood, layerName, "pure-layer node", tech1Name, tech2Name);
            this.doTest(Boolean.FALSE, Boolean.FALSE, mGood, layerName, "pseudo", tech1Name, tech2Name);
        }
        ArrayList<ArcProto> arcs1 = new ArrayList<ArcProto>();
        Iterator<ArcProto> it = tech1.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            if (ap.isNotUsed()) continue;
            arcs1.add(ap);
        }
        ArrayList<ArcProto> arcs2 = new ArrayList<ArcProto>();
        Iterator<ArcProto> it2 = tech2.getArcs();
        while (it2.hasNext()) {
            ArcProto ap = it2.next();
            if (ap.isNotUsed()) continue;
            arcs2.add(ap);
        }
        int maxArcs = Math.max(arcs1.size(), arcs2.size());
        for (int i = 0; i < maxArcs; ++i) {
            int ai1;
            if (i >= arcs1.size()) {
                System.out.println("ERROR: Arc " + ((ArcProto)arcs2.get(i)).getName() + " exists in technology " + tech2.getTechName() + " but not in technology " + tech1.getTechName());
                mGood.setValue(false);
                continue;
            }
            if (i >= arcs2.size()) {
                System.out.println("ERROR: Arc " + ((ArcProto)arcs1.get(i)).getName() + " exists in technology " + tech1.getTechName() + " but not in technology " + tech2.getTechName());
                mGood.setValue(false);
                continue;
            }
            ArcProto ap1 = (ArcProto)arcs1.get(i);
            ArcProto ap2 = (ArcProto)arcs2.get(i);
            this.doTest(ap1.getName(), ap2.getName(), mGood, "Arc " + i, "name", tech1Name, tech2Name);
            String arcName = "Arc " + ap1.getName();
            this.doTest((Object)ap1.getFunction(), (Object)ap2.getFunction(), mGood, arcName, "function", tech1Name, tech2Name);
            this.doTest(ap1.getFactoryDefaultInst().isFixedAngle(), ap2.getFactoryDefaultInst().isFixedAngle(), mGood, arcName, "fixed-angle", tech1Name, tech2Name);
            this.doTest(ap1.isWipable(), ap2.isWipable(), mGood, arcName, "wipable", tech1Name, tech2Name);
            this.doTest(ap1.getFactoryDefaultInst().isTailExtended(), ap2.getFactoryDefaultInst().isTailExtended(), mGood, arcName, "extended", tech1Name, tech2Name);
            this.doTest(ap1.getFactoryAngleIncrement(), ap2.getFactoryAngleIncrement(), mGood, arcName, "angle-increment", tech1Name, tech2Name);
            this.doTest(ap1.getFactoryAntennaRatio(), ap2.getFactoryAntennaRatio(), mGood, arcName, "angle-increment", tech1Name, tech2Name);
            int al1 = ap1.getNumArcLayers();
            int[] nArray = new int[al1];
            for (int j = 0; j < al1; ++j) {
                nArray[j] = -1;
            }
            int al2 = ap2.getNumArcLayers();
            int[] cross2to1 = new int[al2];
            for (int j = 0; j < al2; ++j) {
                cross2to1[j] = -1;
            }
            boolean matched = true;
            if (al1 != al2) {
                matched = false;
            } else {
                for (ai1 = 0; ai1 < al2; ++ai1) {
                    String ai1Name = ap1.getLayer(ai1).getName();
                    for (int ai2 = 0; ai2 < al2; ++ai2) {
                        if (cross2to1[ai2] >= 0 || !ai1Name.equals(ap2.getLayer(ai2).getName())) continue;
                        nArray[ai1] = ai2;
                        cross2to1[ai2] = ai1;
                    }
                }
                for (int j = 0; j < al2; ++j) {
                    if (nArray[j] >= 0 && cross2to1[j] >= 0) continue;
                    matched = false;
                }
            }
            if (!matched) {
                int j;
                String errMsg = "ERROR: " + arcName + " has layers";
                for (j = 0; j < al1; ++j) {
                    errMsg = errMsg + " " + ap1.getLayer(j).getName();
                }
                errMsg = errMsg + " in technology " + tech2.getTechName() + " but layers";
                for (j = 0; j < al2; ++j) {
                    errMsg = errMsg + " " + ap2.getLayer(j).getName();
                }
                errMsg = errMsg + " in technology " + tech1.getTechName();
                System.out.println(errMsg);
                mGood.setValue(false);
                continue;
            }
            for (ai1 = 0; ai1 < al1; ++ai1) {
                int ai2 = nArray[ai1];
                String arcLayerName = arcName + " layer " + ap1.getLayer(ai1).getName();
                this.doTest((Object)ap1.getLayerStyle(ai1), (Object)ap2.getLayerStyle(ai2), mGood, arcLayerName, "layer-style", tech1Name, tech2Name);
                this.doTest(ap1.getLayerExtend(ai1).getLambda(), ap2.getLayerExtend(ai2).getLambda(), mGood, arcLayerName, "layer-extension", tech1Name, tech2Name);
            }
        }
        ArrayList<PrimitiveNode> nodes1 = new ArrayList<PrimitiveNode>();
        Iterator<PrimitiveNode> it3 = tech1.getNodes();
        while (it3.hasNext()) {
            PrimitiveNode np = it3.next();
            boolean ignoreIt = false;
            for (String string : ignoreNodes) {
                if (!np.getName().equalsIgnoreCase(string)) continue;
                ignoreIt = true;
            }
            if (ignoreIt || np.isNotUsed()) continue;
            nodes1.add(np);
        }
        ArrayList<PrimitiveNode> nodes2 = new ArrayList<PrimitiveNode>();
        Iterator<PrimitiveNode> it4 = tech2.getNodes();
        while (it4.hasNext()) {
            PrimitiveNode np = it4.next();
            boolean ignoreIt = false;
            for (String ignoreName : ignoreNodes) {
                if (!np.getName().equalsIgnoreCase(ignoreName)) continue;
                ignoreIt = true;
            }
            if (ignoreIt || np.isNotUsed()) continue;
            nodes2.add(np);
        }
        int maxNodes = Math.max(nodes1.size(), nodes2.size());
        for (int i = 0; i < maxNodes; ++i) {
            int ni1;
            int j;
            boolean adjustSize;
            boolean isSerpentine;
            if (i >= nodes1.size()) {
                System.out.println("ERROR: Node " + ((PrimitiveNode)nodes2.get(i)).getName() + " exists in technology " + tech2.getTechName() + " but not in technology " + tech1.getTechName());
                mGood.setValue(false);
                continue;
            }
            if (i >= nodes2.size()) {
                System.out.println("ERROR: Node " + ((PrimitiveNode)nodes1.get(i)).getName() + " exists in technology " + tech1.getTechName() + " but not in technology " + tech2.getTechName());
                mGood.setValue(false);
                continue;
            }
            PrimitiveNode np1 = (PrimitiveNode)nodes1.get(i);
            PrimitiveNode primitiveNode = (PrimitiveNode)nodes2.get(i);
            this.doTest(np1.getName(), primitiveNode.getName(), mGood, "Node " + i, "name", tech1Name, tech2Name);
            String nodeName = "Node " + np1.getName();
            this.doTest((Object)np1.getFunction(), (Object)primitiveNode.getFunction(), mGood, nodeName, "function", tech1Name, tech2Name);
            this.doTest(np1.isSquare(), primitiveNode.isSquare(), mGood, nodeName, "square", tech1Name, tech2Name);
            this.doTest(np1.isWipeOn1or2(), primitiveNode.isWipeOn1or2(), mGood, nodeName, "wipes-1-or-2", tech1Name, tech2Name);
            this.doTest(np1.isLockedPrim(), primitiveNode.isLockedPrim(), mGood, nodeName, "lockable", tech1Name, tech2Name);
            this.doTest(PrimitiveNode.getSpecialTypeName(np1.getSpecialType()), PrimitiveNode.getSpecialTypeName(primitiveNode.getSpecialType()), mGood, nodeName, "special-type", tech1Name, tech2Name);
            boolean bl = isSerpentine = np1.getSpecialType() == 1 && primitiveNode.getSpecialType() == 1;
            if (isSerpentine) {
                if (!ignoreTransistorFactors.contains(np1.getName())) {
                    this.doTest(np1.getSpecialValues()[0], primitiveNode.getSpecialValues()[0], mGood, nodeName, "serpentine layer count", tech1Name, tech2Name);
                }
                this.doTest(np1.getSpecialValues()[1], primitiveNode.getSpecialValues()[1], mGood, nodeName, "serpentine active port inset from end of serpentine path", tech1Name, tech2Name);
                this.doTest(np1.getSpecialValues()[2], primitiveNode.getSpecialValues()[2], mGood, nodeName, "serpentine active port inset from poly edge", tech1Name, tech2Name);
                this.doTest(np1.getSpecialValues()[3], primitiveNode.getSpecialValues()[3], mGood, nodeName, "serpentine poly width", tech1Name, tech2Name);
                this.doTest(np1.getSpecialValues()[4], primitiveNode.getSpecialValues()[4], mGood, nodeName, "serpentine poly port inset from poly edge", tech1Name, tech2Name);
                this.doTest(np1.getSpecialValues()[5], primitiveNode.getSpecialValues()[5], mGood, nodeName, "serpentine poly port instet from active edge", tech1Name, tech2Name);
            }
            SizeOffset so1 = np1.getProtoSizeOffset();
            SizeOffset so2 = primitiveNode.getProtoSizeOffset();
            this.doTest(np1.getDefWidth(ep) - so1.getLowXOffset() - so1.getHighXOffset(), primitiveNode.getDefWidth(ep) - so2.getLowXOffset() - so2.getHighXOffset(), mGood, nodeName, "default-width", tech1Name, tech2Name);
            this.doTest(np1.getDefHeight(ep) - so1.getLowYOffset() - so1.getHighYOffset(), primitiveNode.getDefHeight(ep) - so2.getLowYOffset() - so2.getHighYOffset(), mGood, nodeName, "default-height", tech1Name, tech2Name);
            double sizeX1 = np1.getDefSize(ep).getLambdaX();
            double sizeY1 = np1.getDefSize(ep).getLambdaY();
            double sizeX2 = primitiveNode.getDefSize(ep).getLambdaX();
            double sizeY2 = primitiveNode.getDefSize(ep).getLambdaY();
            boolean bl2 = adjustSize = sizeX1 != sizeX2 || sizeY1 != sizeY2;
            if (!(adjustSize || ignoreNodeSize.contains(np1.getName()) || ignoreTransistorFactors.contains(np1.getName()))) {
                this.doTest(so1.getLowXOffset(), so2.getLowXOffset(), mGood, nodeName, "low-X-offset", tech1Name, tech2Name);
                this.doTest(so1.getHighXOffset(), so2.getHighXOffset(), mGood, nodeName, "high-X-offset", tech1Name, tech2Name);
                this.doTest(so1.getLowYOffset(), so2.getLowYOffset(), mGood, nodeName, "low-Y-offset", tech1Name, tech2Name);
                this.doTest(so1.getHighYOffset(), so2.getHighYOffset(), mGood, nodeName, "high-Y-offset", tech1Name, tech2Name);
            }
            Technology.NodeLayer[] nlays1 = np1.getNodeLayers();
            int nl1 = nlays1.length;
            int[] cross1to2 = new int[nl1];
            for (int j2 = 0; j2 < nl1; ++j2) {
                cross1to2[j2] = -1;
            }
            Technology.NodeLayer[] nlays2 = primitiveNode.getNodeLayers();
            int nl2 = nlays2.length;
            int[] cross2to1 = new int[nl2];
            for (int j3 = 0; j3 < nl2; ++j3) {
                cross2to1[j3] = -1;
            }
            boolean matched = true;
            if (nl1 != nl2) {
                matched = false;
            } else {
                for (int ni12 = 0; ni12 < nl2; ++ni12) {
                    String ni1Name = nlays1[ni12].getLayer().getName();
                    for (int ni2 = 0; ni2 < nl2; ++ni2) {
                        if (cross2to1[ni2] >= 0 || !ni1Name.equals(nlays2[ni2].getLayer().getName())) continue;
                        cross1to2[ni12] = ni2;
                        cross2to1[ni2] = ni12;
                    }
                }
                for (int j4 = 0; j4 < nl2; ++j4) {
                    if (cross1to2[j4] >= 0 && cross2to1[j4] >= 0) continue;
                    matched = false;
                }
            }
            if (!matched) {
                String errMsg = "ERROR: " + nodeName + " has layers";
                for (int j5 = 0; j5 < nl1; ++j5) {
                    errMsg = errMsg + " " + nlays1[j5].getLayer().getName();
                }
                errMsg = errMsg + " in technology " + tech2.getTechName() + " but layers";
                for (int j2 = 0; j2 < nl2; ++j2) {
                    errMsg = errMsg + " " + nlays2[j2].getLayer().getName();
                }
                errMsg = errMsg + " in technology " + tech1.getTechName();
                System.out.println(errMsg);
                mGood.setValue(false);
            } else {
                for (int ni12 = 0; ni12 < nl1; ++ni12) {
                    int ni2 = cross1to2[ni12];
                    String nodeLayerName = nodeName + " layer " + nlays1[ni12].getLayer().getName();
                    this.doTest((Object)nlays1[ni12].getStyle(), (Object)nlays2[ni2].getStyle(), mGood, nodeLayerName, "layer-style", tech1Name, tech2Name);
                    if (!ignoreTransistorFactors.contains(np1.getName())) {
                        this.doTest(nlays1[ni12].getPortNum(), nlays2[ni2].getPortNum(), mGood, nodeLayerName, "port-num", tech1Name, tech2Name);
                    }
                    int r1 = nlays1[ni12].getRepresentation();
                    int r2 = nlays2[ni2].getRepresentation();
                    this.doTest(Technology.NodeLayer.getRepresentationName(r1), Technology.NodeLayer.getRepresentationName(r2), mGood, nodeLayerName, "layer-representation", tech1Name, tech2Name);
                    if (adjustSize) {
                        EdgeV botEdge1 = nlays1[ni12].getBottomEdge();
                        EdgeV botEdge2 = nlays2[ni2].getBottomEdge();
                        this.doTest(botEdge1.getMultiplier() * sizeY1 + botEdge1.getAdder().getLambda(), botEdge2.getMultiplier() * sizeY2 + botEdge2.getAdder().getLambda(), mGood, nodeLayerName, "bottom-edge", tech1Name, tech2Name);
                        EdgeV topEdge1 = nlays1[ni12].getTopEdge();
                        EdgeV topEdge2 = nlays2[ni2].getTopEdge();
                        this.doTest(topEdge1.getMultiplier() * sizeY1 + topEdge1.getAdder().getLambda(), topEdge2.getMultiplier() * sizeY2 + topEdge2.getAdder().getLambda(), mGood, nodeLayerName, "top-edge", tech1Name, tech2Name);
                        EdgeH lftEdge1 = nlays1[ni12].getLeftEdge();
                        EdgeH lftEdge2 = nlays2[ni2].getLeftEdge();
                        this.doTest(lftEdge1.getMultiplier() * sizeX1 + lftEdge1.getAdder().getLambda(), lftEdge2.getMultiplier() * sizeX2 + lftEdge2.getAdder().getLambda(), mGood, nodeLayerName, "left-edge", tech1Name, tech2Name);
                        EdgeH rgtEdge1 = nlays1[ni12].getRightEdge();
                        EdgeH rgtEdge2 = nlays2[ni2].getRightEdge();
                        this.doTest(rgtEdge1.getMultiplier() * sizeX1 + rgtEdge1.getAdder().getLambda(), rgtEdge2.getMultiplier() * sizeX2 + rgtEdge2.getAdder().getLambda(), mGood, nodeLayerName, "right-edge", tech1Name, tech2Name);
                    } else {
                        this.doTest(nlays1[ni12].getBottomEdge(), nlays2[ni2].getBottomEdge(), mGood, nodeLayerName, "bottom-edge", tech1Name, tech2Name);
                        this.doTest(nlays1[ni12].getTopEdge(), nlays2[ni2].getTopEdge(), mGood, nodeLayerName, "top-edge", tech1Name, tech2Name);
                        this.doTest(nlays1[ni12].getLeftEdge(), nlays2[ni2].getLeftEdge(), mGood, nodeLayerName, "left-edge", tech1Name, tech2Name);
                        this.doTest(nlays1[ni12].getRightEdge(), nlays2[ni2].getRightEdge(), mGood, nodeLayerName, "right-edge", tech1Name, tech2Name);
                    }
                    if (nlays1[ni12].getRepresentation() == 3) {
                        this.doTest(nlays1[ni12].getMulticutSep1D(), nlays2[ni2].getMulticutSep1D(), mGood, nodeLayerName, "multicut-X-separation", tech1Name, tech2Name);
                        this.doTest(nlays1[ni12].getMulticutSep2D(), nlays2[ni2].getMulticutSep2D(), mGood, nodeLayerName, "multicut-Y-separation", tech1Name, tech2Name);
                        this.doTest(nlays1[ni12].getMulticutSizeX(), nlays2[ni2].getMulticutSizeX(), mGood, nodeLayerName, "multicut-X-size", tech1Name, tech2Name);
                        this.doTest(nlays1[ni12].getMulticutSizeY(), nlays2[ni2].getMulticutSizeY(), mGood, nodeLayerName, "multicut-Y-size", tech1Name, tech2Name);
                    }
                    if (!isSerpentine) continue;
                    this.doTest(nlays1[ni12].getSerpentineExtentB(), nlays2[ni2].getSerpentineExtentB(), mGood, nodeLayerName, "serpentine bottom extend", tech1Name, tech2Name);
                    this.doTest(nlays1[ni12].getSerpentineExtentT(), nlays2[ni2].getSerpentineExtentT(), mGood, nodeLayerName, "serpentine top extend", tech1Name, tech2Name);
                    this.doTest(nlays1[ni12].getSerpentineLWidth(), nlays2[ni2].getSerpentineLWidth(), mGood, nodeLayerName, "serpentine left width", tech1Name, tech2Name);
                    this.doTest(nlays1[ni12].getSerpentineRWidth(), nlays2[ni2].getSerpentineRWidth(), mGood, nodeLayerName, "serpentine right width", tech1Name, tech2Name);
                }
            }
            int npTot1 = np1.getNumPorts();
            cross1to2 = new int[npTot1];
            for (int j6 = 0; j6 < npTot1; ++j6) {
                cross1to2[j6] = -1;
            }
            int npTot2 = primitiveNode.getNumPorts();
            cross2to1 = new int[npTot2];
            for (j = 0; j < npTot2; ++j) {
                cross2to1[j] = -1;
            }
            matched = true;
            if (npTot1 != npTot2) {
                matched = false;
            } else {
                for (ni1 = 0; ni1 < npTot2; ++ni1) {
                    String ni1Name = np1.getPort(ni1).getName();
                    for (int ni2 = 0; ni2 < npTot2; ++ni2) {
                        if (cross2to1[ni2] >= 0 || !ni1Name.equals(primitiveNode.getPort(ni2).getName())) continue;
                        cross1to2[ni1] = ni2;
                        cross2to1[ni2] = ni1;
                    }
                }
                for (j = 0; j < npTot2; ++j) {
                    if (cross1to2[j] >= 0 && cross2to1[j] >= 0) continue;
                    matched = false;
                }
            }
            if (!matched) {
                String errMsg = "ERROR: " + nodeName + " has ports";
                for (int j7 = 0; j7 < npTot1; ++j7) {
                    errMsg = errMsg + " " + np1.getPort(j7).getName();
                }
                errMsg = errMsg + " in technology " + tech2.getTechName() + " but ports";
                for (int j3 = 0; j3 < npTot2; ++j3) {
                    errMsg = errMsg + " " + primitiveNode.getPort(j3).getName();
                }
                errMsg = errMsg + " in technology " + tech1.getTechName();
                System.out.println(errMsg);
                mGood.setValue(false);
                continue;
            }
            for (ni1 = 0; ni1 < npTot1; ++ni1) {
                int ni2 = cross1to2[ni1];
                PrimitivePort pp1 = np1.getPort(ni1);
                PrimitivePort pp2 = primitiveNode.getPort(ni2);
                String nodePortName = nodeName + " port " + pp1.getName();
                if (adjustSize) {
                    EdgeV botEdge1 = pp1.getBottom();
                    EdgeV botEdge2 = pp2.getBottom();
                    this.doTest(botEdge1.getMultiplier() * sizeY1 + botEdge1.getAdder().getLambda(), botEdge2.getMultiplier() * sizeY2 + botEdge2.getAdder().getLambda(), mGood, nodePortName, "bottom-edge", tech1Name, tech2Name);
                    EdgeV topEdge1 = pp1.getTop();
                    EdgeV topEdge2 = pp2.getTop();
                    this.doTest(topEdge1.getMultiplier() * sizeY1 + topEdge1.getAdder().getLambda(), topEdge2.getMultiplier() * sizeY2 + topEdge2.getAdder().getLambda(), mGood, nodePortName, "top-edge", tech1Name, tech2Name);
                    EdgeH lftEdge1 = pp1.getLeft();
                    EdgeH lftEdge2 = pp2.getLeft();
                    this.doTest(lftEdge1.getMultiplier() * sizeX1 + lftEdge1.getAdder().getLambda(), lftEdge2.getMultiplier() * sizeX2 + lftEdge2.getAdder().getLambda(), mGood, nodePortName, "left-edge", tech1Name, tech2Name);
                    EdgeH rgtEdge1 = pp1.getRight();
                    EdgeH rgtEdge2 = pp2.getRight();
                    this.doTest(rgtEdge1.getMultiplier() * sizeX1 + rgtEdge1.getAdder().getLambda(), rgtEdge2.getMultiplier() * sizeX2 + rgtEdge2.getAdder().getLambda(), mGood, nodePortName, "right-edge", tech1Name, tech2Name);
                } else {
                    this.doTest(pp1.getBottom(), pp2.getBottom(), mGood, nodePortName, "bottom-edge", tech1Name, tech2Name);
                    this.doTest(pp1.getTop(), pp2.getTop(), mGood, nodePortName, "top-edge", tech1Name, tech2Name);
                    this.doTest(pp1.getLeft(), pp2.getLeft(), mGood, nodePortName, "left-edge", tech1Name, tech2Name);
                    this.doTest(pp1.getRight(), pp2.getRight(), mGood, nodePortName, "right-edge", tech1Name, tech2Name);
                }
                if (!ignoreTransistorFactors.contains(np1.getName())) {
                    this.doTest(pp1.getTopology(), pp2.getTopology(), mGood, nodePortName, "topology", tech1Name, tech2Name);
                }
                this.doTest(pp1.getAngle(), pp2.getAngle(), mGood, nodePortName, "angle", tech1Name, tech2Name);
                this.doTest(pp1.getAngleRange(), pp2.getAngleRange(), mGood, nodePortName, "angle", tech1Name, tech2Name);
                ArcProto[] pp1Conn = pp1.getConnections();
                ArcProto[] pp2Conn = pp2.getConnections();
                boolean connSame = true;
                for (int i1 = 0; i1 < pp1Conn.length; ++i1) {
                    if (pp1Conn[i1].getTechnology() == Generic.tech() || pp1Conn[i1].isNotUsed()) continue;
                    boolean found = false;
                    for (int i2 = 0; i2 < pp2Conn.length; ++i2) {
                        if (!pp1Conn[i1].getName().equals(pp2Conn[i2].getName())) continue;
                        found = true;
                    }
                    if (found) continue;
                    connSame = false;
                }
                for (int i2 = 0; i2 < pp2Conn.length; ++i2) {
                    if (pp2Conn[i2].isNotUsed() || pp2Conn[i2].getTechnology() == Generic.tech()) continue;
                    boolean found = false;
                    for (int i1 = 0; i1 < pp2Conn.length; ++i1) {
                        if (!pp2Conn[i2].getName().equals(pp1Conn[i1].getName())) continue;
                        found = true;
                    }
                    if (found) continue;
                    connSame = false;
                }
                if (connSame) continue;
                String errMsg = "ERROR: " + nodePortName + " connects to";
                for (int j8 = 0; j8 < pp1Conn.length; ++j8) {
                    if (pp1Conn[j8].getTechnology() == Generic.tech()) continue;
                    errMsg = errMsg + " " + pp1Conn[j8].getName();
                }
                errMsg = errMsg + " in technology " + tech2.getTechName() + " but connects to";
                for (int j4 = 0; j4 < pp2Conn.length; ++j4) {
                    if (pp2Conn[j4].getTechnology() == Generic.tech()) continue;
                    errMsg = errMsg + " " + pp2Conn[j4].getName();
                }
                errMsg = errMsg + " in technology " + tech1.getTechName();
                System.out.println(errMsg);
                mGood.setValue(false);
            }
        }
        return mGood.booleanValue();
    }

    private void doTest(Object obj1, Object obj2, MutableBoolean good, String objectName, String attrName, String obj1Name, String obj2Name) {
        if (!obj1.equals(obj2)) {
            Object errMsg = "ERROR: ";
            errMsg = objectName == null ? (String)errMsg + "found" : (String)errMsg + objectName + " has ";
            errMsg = (String)errMsg + attrName + " '" + obj1 + "' in " + obj1Name + " but " + attrName + " '" + obj2 + "' in " + obj2Name;
            System.out.println((String)errMsg);
            good.setValue(false);
        }
    }
}

