/* SPDX-License-Identifier: GPL-2.0-only */

#include <mipi/panel.h>

struct panel_serializable_data BOE_TV101WUM_NG0 = {
	.edid = {
		.ascii_string = "TV101WUM-NG0",
		.manufacturer_name = "BOE",
		.panel_bits_per_color = 8,
		.panel_bits_per_pixel = 24,
		.mode = {
			.pixel_clock = 159420,
			.lvds_dual_channel = 0,
			.refresh = 60,
			.ha = 1200, .hbl = 164, .hso = 80, .hspw = 24,
			.va = 1920, .vbl = 28, .vso = 10, .vspw = 4,
			.phsync = '-', .pvsync = '-',
			.x_mm = 135, .y_mm = 216,
		},
	},
	.init = {
		PANEL_DCS(0x10),
		PANEL_DELAY(0x22),
		PANEL_DCS(0xB0, 0x05),
		PANEL_DCS(0xB1, 0xE5),
		PANEL_DCS(0xB3, 0x52),
		PANEL_DCS(0xB0, 0x00),
		PANEL_DCS(0xB3, 0x88),
		PANEL_DCS(0xB0, 0x04),
		PANEL_DCS(0xB8, 0x00),
		PANEL_DCS(0xB0, 0x00),
		PANEL_DCS(0xB2, 0x50),
		PANEL_DCS(0xB6, 0x03),
		PANEL_DCS(0xBA, 0x8B),
		PANEL_DCS(0xBF, 0x15),
		PANEL_DCS(0xC0, 0x0F),
		PANEL_DCS(0xC2, 0x0C),
		PANEL_DCS(0xC3, 0x02),
		PANEL_DCS(0xC4, 0x0C),
		PANEL_DCS(0xC5, 0x02),
		PANEL_DCS(0xB0, 0x01),
		PANEL_DCS(0xE0, 0x26),
		PANEL_DCS(0xE1, 0x26),
		PANEL_DCS(0xDC, 0x00),
		PANEL_DCS(0xDD, 0x00),
		PANEL_DCS(0xCC, 0x26),
		PANEL_DCS(0xCD, 0x26),
		PANEL_DCS(0xC8, 0x00),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xD2, 0x04),
		PANEL_DCS(0xD3, 0x04),
		PANEL_DCS(0xE6, 0x03),
		PANEL_DCS(0xE7, 0x03),
		PANEL_DCS(0xC4, 0x08),
		PANEL_DCS(0xC5, 0x08),
		PANEL_DCS(0xD8, 0x07),
		PANEL_DCS(0xD9, 0x07),
		PANEL_DCS(0xC2, 0x06),
		PANEL_DCS(0xC3, 0x06),
		PANEL_DCS(0xD6, 0x05),
		PANEL_DCS(0xD7, 0x05),
		PANEL_DCS(0xC0, 0x0C),
		PANEL_DCS(0xC1, 0x0C),
		PANEL_DCS(0xD4, 0x0B),
		PANEL_DCS(0xD5, 0x0B),
		PANEL_DCS(0xCA, 0x0A),
		PANEL_DCS(0xCB, 0x0A),
		PANEL_DCS(0xDE, 0x09),
		PANEL_DCS(0xDF, 0x09),
		PANEL_DCS(0xC6, 0x26),
		PANEL_DCS(0xC7, 0x26),
		PANEL_DCS(0xCE, 0x00),
		PANEL_DCS(0xCF, 0x00),
		PANEL_DCS(0xDA, 0x26),
		PANEL_DCS(0xDB, 0x26),
		PANEL_DCS(0xE2, 0x00),
		PANEL_DCS(0xE3, 0x00),
		PANEL_DCS(0xB0, 0x02),
		PANEL_DCS(0xC0, 0x00),
		PANEL_DCS(0xC1, 0x07),
		PANEL_DCS(0xC2, 0x0D),
		PANEL_DCS(0xC3, 0x18),
		PANEL_DCS(0xC4, 0x27),
		PANEL_DCS(0xC5, 0x28),
		PANEL_DCS(0xC6, 0x30),
		PANEL_DCS(0xC7, 0x2E),
		PANEL_DCS(0xC8, 0x2F),
		PANEL_DCS(0xC9, 0x1A),
		PANEL_DCS(0xCA, 0x20),
		PANEL_DCS(0xCB, 0x29),
		PANEL_DCS(0xCC, 0x26),
		PANEL_DCS(0xCD, 0x32),
		PANEL_DCS(0xCE, 0x33),
		PANEL_DCS(0xCF, 0x31),
		PANEL_DCS(0xD0, 0x06),
		PANEL_DCS(0xD2, 0x00),
		PANEL_DCS(0xD3, 0x07),
		PANEL_DCS(0xD4, 0x12),
		PANEL_DCS(0xD5, 0x26),
		PANEL_DCS(0xD6, 0x3D),
		PANEL_DCS(0xD7, 0x3F),
		PANEL_DCS(0xD8, 0x3F),
		PANEL_DCS(0xD9, 0x3F),
		PANEL_DCS(0xDA, 0x3F),
		PANEL_DCS(0xDB, 0x3F),
		PANEL_DCS(0xDC, 0x3F),
		PANEL_DCS(0xDD, 0x3F),
		PANEL_DCS(0xDE, 0x3F),
		PANEL_DCS(0xDF, 0x3A),
		PANEL_DCS(0xE0, 0x37),
		PANEL_DCS(0xE1, 0x35),
		PANEL_DCS(0xE2, 0x07),
		PANEL_DCS(0xB0, 0x03),
		PANEL_DCS(0xC8, 0x0B),
		PANEL_DCS(0xC9, 0x07),
		PANEL_DCS(0xC3, 0x00),
		PANEL_DCS(0xE7, 0x00),
		PANEL_DCS(0xC5, 0x2A),
		PANEL_DCS(0xDE, 0x2A),
		PANEL_DCS(0xCA, 0x43),
		PANEL_DCS(0xC9, 0x07),
		PANEL_DCS(0xE4, 0xC0),
		PANEL_DCS(0xE5, 0x0D),
		PANEL_DCS(0xCB, 0x00),
		PANEL_DCS(0xB0, 0x06),
		PANEL_DCS(0xB8, 0xA5),
		PANEL_DCS(0xC0, 0xA5),
		PANEL_DCS(0xC7, 0x0F),
		PANEL_DCS(0xD5, 0x32),
		PANEL_DCS(0xB8, 0x00),
		PANEL_DCS(0xC0, 0x00),
		PANEL_DCS(0xBC, 0x00),
		PANEL_DCS(0xB0, 0x07),
		PANEL_DCS(0xB1, 0x00),
		PANEL_DCS(0xB2, 0x09),
		PANEL_DCS(0xB3, 0x19),
		PANEL_DCS(0xB4, 0x2F),
		PANEL_DCS(0xB5, 0x44),
		PANEL_DCS(0xB6, 0x52),
		PANEL_DCS(0xB7, 0x6A),
		PANEL_DCS(0xB8, 0x8A),
		PANEL_DCS(0xB9, 0xCA),
		PANEL_DCS(0xBA, 0x0C),
		PANEL_DCS(0xBB, 0x87),
		PANEL_DELAY(0x05),
		PANEL_DCS(0xBC, 0x06),
		PANEL_DCS(0xBD, 0x0A),
		PANEL_DCS(0xBE, 0x9B),
		PANEL_DCS(0xBF, 0x0C),
		PANEL_DCS(0xC0, 0x3D),
		PANEL_DCS(0xC1, 0x71),
		PANEL_DCS(0xC2, 0x90),
		PANEL_DCS(0xC3, 0xA0),
		PANEL_DCS(0xC4, 0xA8),
		PANEL_DCS(0xC5, 0xB1),
		PANEL_DCS(0xC6, 0xBB),
		PANEL_DCS(0xC7, 0xC0),
		PANEL_DCS(0xC8, 0xC4),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xCA, 0x00),
		PANEL_DCS(0xCB, 0x16),
		PANEL_DCS(0xCC, 0xAF),
		PANEL_DCS(0xCD, 0xFF),
		PANEL_DCS(0xCE, 0xFF),
		PANEL_DCS(0xB0, 0x08),
		PANEL_DCS(0xB1, 0x04),
		PANEL_DCS(0xB2, 0x08),
		PANEL_DCS(0xB3, 0x19),
		PANEL_DCS(0xB4, 0x31),
		PANEL_DCS(0xB5, 0x46),
		PANEL_DCS(0xB6, 0x55),
		PANEL_DCS(0xB7, 0x6E),
		PANEL_DCS(0xB8, 0x92),
		PANEL_DCS(0xB9, 0xD4),
		PANEL_DCS(0xBA, 0x1B),
		PANEL_DCS(0xBB, 0x9B),
		PANEL_DELAY(0x05),
		PANEL_DCS(0xBC, 0x28),
		PANEL_DCS(0xBD, 0x2D),
		PANEL_DCS(0xBE, 0xC3),
		PANEL_DCS(0xBF, 0x2F),
		PANEL_DCS(0xC0, 0x62),
		PANEL_DCS(0xC1, 0x99),
		PANEL_DCS(0xC2, 0xAB),
		PANEL_DCS(0xC3, 0xBF),
		PANEL_DCS(0xC4, 0xCF),
		PANEL_DCS(0xC5, 0xDF),
		PANEL_DCS(0xC6, 0xF0),
		PANEL_DCS(0xC7, 0xF9),
		PANEL_DCS(0xC8, 0xFC),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xCA, 0x00),
		PANEL_DCS(0xCB, 0x16),
		PANEL_DCS(0xCC, 0xAF),
		PANEL_DCS(0xCD, 0xFF),
		PANEL_DCS(0xCE, 0xFF),
		PANEL_DCS(0xB0, 0x09),
		PANEL_DCS(0xB1, 0x04),
		PANEL_DCS(0xB2, 0x05),
		PANEL_DCS(0xB3, 0x17),
		PANEL_DCS(0xB4, 0x2E),
		PANEL_DCS(0xB5, 0x42),
		PANEL_DCS(0xB6, 0x51),
		PANEL_DCS(0xB7, 0x69),
		PANEL_DCS(0xB8, 0x88),
		PANEL_DCS(0xB9, 0xC9),
		PANEL_DCS(0xBA, 0x0C),
		PANEL_DCS(0xBB, 0x86),
		PANEL_DELAY(0x05),
		PANEL_DCS(0xBC, 0x03),
		PANEL_DCS(0xBD, 0x08),
		PANEL_DCS(0xBE, 0x95),
		PANEL_DCS(0xBF, 0x05),
		PANEL_DCS(0xC0, 0x35),
		PANEL_DCS(0xC1, 0x62),
		PANEL_DCS(0xC2, 0x81),
		PANEL_DCS(0xC3, 0x96),
		PANEL_DCS(0xC4, 0x9E),
		PANEL_DCS(0xC5, 0xA5),
		PANEL_DCS(0xC6, 0xAD),
		PANEL_DCS(0xC7, 0xB1),
		PANEL_DCS(0xC8, 0xB4),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xCA, 0x00),
		PANEL_DCS(0xCB, 0x16),
		PANEL_DCS(0xCC, 0xAF),
		PANEL_DCS(0xCD, 0xFF),
		PANEL_DCS(0xCE, 0xFF),
		PANEL_DCS(0xB0, 0x0A),
		PANEL_DCS(0xB1, 0x00),
		PANEL_DCS(0xB2, 0x09),
		PANEL_DCS(0xB3, 0x19),
		PANEL_DCS(0xB4, 0x2F),
		PANEL_DCS(0xB5, 0x44),
		PANEL_DCS(0xB6, 0x52),
		PANEL_DCS(0xB7, 0x6A),
		PANEL_DCS(0xB8, 0x8A),
		PANEL_DCS(0xB9, 0xCA),
		PANEL_DCS(0xBA, 0x0C),
		PANEL_DCS(0xBB, 0x87),
		PANEL_DELAY(0x05),
		PANEL_DCS(0xBC, 0x06),
		PANEL_DCS(0xBD, 0x0A),
		PANEL_DCS(0xBE, 0x9B),
		PANEL_DCS(0xBF, 0x0C),
		PANEL_DCS(0xC0, 0x3D),
		PANEL_DCS(0xC1, 0x71),
		PANEL_DCS(0xC2, 0x90),
		PANEL_DCS(0xC3, 0xA0),
		PANEL_DCS(0xC4, 0xA8),
		PANEL_DCS(0xC5, 0xB1),
		PANEL_DCS(0xC6, 0xBB),
		PANEL_DCS(0xC7, 0xC0),
		PANEL_DCS(0xC8, 0xC4),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xCA, 0x00),
		PANEL_DCS(0xCB, 0x16),
		PANEL_DCS(0xCC, 0xAF),
		PANEL_DCS(0xCD, 0xFF),
		PANEL_DCS(0xCE, 0xFF),
		PANEL_DCS(0xB0, 0x0B),
		PANEL_DCS(0xB1, 0x04),
		PANEL_DCS(0xB2, 0x08),
		PANEL_DCS(0xB3, 0x19),
		PANEL_DCS(0xB4, 0x31),
		PANEL_DCS(0xB5, 0x46),
		PANEL_DCS(0xB6, 0x55),
		PANEL_DCS(0xB7, 0x6E),
		PANEL_DCS(0xB8, 0x92),
		PANEL_DCS(0xB9, 0xD4),
		PANEL_DCS(0xBA, 0x1B),
		PANEL_DCS(0xBB, 0x9B),
		PANEL_DELAY(0x05),
		PANEL_DCS(0xBC, 0x28),
		PANEL_DCS(0xBD, 0x2D),
		PANEL_DCS(0xBE, 0xC3),
		PANEL_DCS(0xBF, 0x2F),
		PANEL_DCS(0xC0, 0x62),
		PANEL_DCS(0xC1, 0x99),
		PANEL_DCS(0xC2, 0xAB),
		PANEL_DCS(0xC3, 0xBF),
		PANEL_DCS(0xC4, 0xCF),
		PANEL_DCS(0xC5, 0xDF),
		PANEL_DCS(0xC6, 0xF0),
		PANEL_DCS(0xC7, 0xF9),
		PANEL_DCS(0xC8, 0xFC),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xCA, 0x00),
		PANEL_DCS(0xCB, 0x16),
		PANEL_DCS(0xCC, 0xAF),
		PANEL_DCS(0xCD, 0xFF),
		PANEL_DCS(0xCE, 0xFF),
		PANEL_DCS(0xB0, 0x0C),
		PANEL_DCS(0xB1, 0x04),
		PANEL_DCS(0xB2, 0x05),
		PANEL_DCS(0xB3, 0x17),
		PANEL_DCS(0xB4, 0x2E),
		PANEL_DCS(0xB5, 0x42),
		PANEL_DCS(0xB6, 0x51),
		PANEL_DCS(0xB7, 0x69),
		PANEL_DCS(0xB8, 0x88),
		PANEL_DCS(0xB9, 0xC9),
		PANEL_DCS(0xBA, 0x0C),
		PANEL_DCS(0xBB, 0x86),
		PANEL_DELAY(0x05),
		PANEL_DCS(0xBC, 0x03),
		PANEL_DCS(0xBD, 0x08),
		PANEL_DCS(0xBE, 0x95),
		PANEL_DCS(0xBF, 0x05),
		PANEL_DCS(0xC0, 0x35),
		PANEL_DCS(0xC1, 0x62),
		PANEL_DCS(0xC2, 0x81),
		PANEL_DCS(0xC3, 0x96),
		PANEL_DCS(0xC4, 0x9E),
		PANEL_DCS(0xC5, 0xA5),
		PANEL_DCS(0xC6, 0xAD),
		PANEL_DCS(0xC7, 0xB1),
		PANEL_DCS(0xC8, 0xB4),
		PANEL_DCS(0xC9, 0x00),
		PANEL_DCS(0xCA, 0x00),
		PANEL_DCS(0xCB, 0x16),
		PANEL_DCS(0xCC, 0xAF),
		PANEL_DCS(0xCD, 0xFF),
		PANEL_DCS(0xCE, 0xFF),
		PANEL_DELAY(0x64),
		PANEL_DCS(0xB0, 0x00),
		PANEL_DCS(0xB3, 0x08),
		PANEL_DCS(0xB0, 0x04),
		PANEL_DCS(0xB8, 0x68),
		PANEL_DELAY(0x0A),
		PANEL_DCS(0x11),
		PANEL_DELAY(0x78),
		PANEL_DCS(0x29),
		PANEL_DELAY(0x14),
		PANEL_END,
	},
};
