#!/bin/bash
set -e

[ ! -d prebuilt ] && git worktree add -f prebuilt prebuilt && exit 1

if output=$(git status --porcelain) && [ ! -z "$output" ]; then
  echo Cannot apply to a dirty working tree, please stage your changes 
  exit 1
fi

# make sure that the prebuilt directory is clean
# before building
# this script is part of the make prebuilt
cd prebuilt
git checkout -- .
git pull
