## HTTP Clients

This folder contain class or function specifically designed to facilitate HTTP client
interactions with a the core systems.

These API defines:

1.  **API Communication**: Handle communication with the component API,
    abstracting away the details of HTTP requests and responses.
    This includes making GET, POST, PUT, and DELETE requests to the servers.
2.  **Data Formatting**: Responsible for formatting requests to the API in a
    way that's expected by the servers (JSON) and parsing the responses back
    into formats usable by the client.
3.  **Authentication and Security**: Handling authentication with the server API,
    which could involve sending API keys, client credentials, or managing tokens.
    It might also implement security features to ensure data integrity and confidentiality during transit.
4.  **Error Handling**: Providing robust error handling and retry mechanisms
    for failed HTTP requests, including logging and potentially user notifications for critical failures.
5.  **Data Validation**: Before sending requests, it could validate the data to ensure it meets the API's expected format, types, and value ranges, reducing the likelihood of errors and improving system reliability.

## Design decisions

The https clients follows this decisions for consistency.

To make it easier to keep track with the spec:
 * One API component per file.
 * All functions should have a comment that points to the respective Spec
 * All functions should be in order as described in the spec

To make it easier to spot incomatible usage use strong typing:
 * If the request ended successfully (the operation is committed or the data return is the expected) then return OperationOk
 * If the operation fail with an error code documented in the spec then return OperationFail (or OperationAlternative if the failure contains a body)
 * If the response contains any other error or the response is unreadable then throw an TalerError with all the information
 * Function arguments should use types from the protocol when possible

To make it easier to reuse
 * Class instance should be thread safe and methods should be reentrant
 * Only use Taler HttpRequestLibrary interface to make a request
 * Do not expose http: URL parameters and Headers can be string arguments
