/*
 This file is part of GNU Taler
 (C) 2021 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import { Translator } from "./i18n.js";

// From https://en.wikipedia.org/wiki/ISO_3166

export const enum CountryCode {
  AF = "AF",
  AL = "AL",
  DZ = "DZ",
  US = "US",
  AD = "AD",
  AO = "AO",
  AG = "AG",
  AR = "AR",
  AM = "AM",
  AU = "AU",
  AT = "AT",
  AZ = "AZ",
  BS = "BS",
  BH = "BH",
  BD = "BD",
  BB = "BB",
  BW = "BW",
  BY = "BY",
  BE = "BE",
  BZ = "BZ",
  BJ = "BJ",
  BT = "BT",
  BO = "BO",
  BA = "BA",
  BR = "BR",
  GB = "GB",
  BN = "BN",
  BG = "BG",
  BF = "BF",
  MM = "MM",
  BI = "BI",
  KH = "KH",
  CM = "CM",
  CA = "CA",
  CV = "CV",
  CF = "CF",
  TD = "TD",
  CL = "CL",
  CN = "CN",
  CO = "CO",
  KM = "KM",
  CD = "CD",
  CG = "CG",
  CR = "CR",
  HR = "HR",
  CU = "CU",
  CY = "CY",
  CZ = "CZ",
  DK = "DK",
  DJ = "DJ",
  DO = "DO",
  NL = "NL",
  TL = "TL",
  EC = "EC",
  EG = "EG",
  AE = "AE",
  GQ = "GQ",
  ER = "ER",
  EE = "EE",
  ET = "ET",
  FJ = "FJ",
  PH = "PH",
  FI = "FI",
  FR = "FR",
  GA = "GA",
  GM = "GM",
  GE = "GE",
  DE = "DE",
  GH = "GH",
  GR = "GR",
  GD = "GD",
  GT = "GT",
  GW = "GW",
  GN = "GN",
  GY = "GY",
  HT = "HT",
  HN = "HN",
  HU = "HU",
  KI = "KI",
  IS = "IS",
  IN = "IN",
  ID = "ID",
  IR = "IR",
  IQ = "IQ",
  IE = "IE",
  IL = "IL",
  IT = "IT",
  CI = "CI",
  JM = "JM",
  JP = "JP",
  JO = "JO",
  KZ = "KZ",
  KE = "KE",
  KN = "KN",
  KW = "KW",
  KG = "KG",
  LA = "LA",
  LV = "LV",
  LB = "LB",
  LR = "LR",
  LY = "LY",
  LI = "LI",
  LT = "LT",
  LU = "LU",
  MK = "MK",
  MG = "MG",
  MW = "MW",
  MY = "MY",
  MV = "MV",
  ML = "ML",
  MT = "MT",
  MH = "MH",
  MR = "MR",
  MU = "MU",
  MX = "MX",
  FM = "FM",
  MD = "MD",
  MC = "MC",
  MN = "MN",
  MA = "MA",
  LS = "LS",
  MZ = "MZ",
  NA = "NA",
  NR = "NR",
  NP = "NP",
  NZ = "NZ",
  VU = "VU",
  NI = "NI",
  NG = "NG",
  NE = "NE",
  KP = "KP",
  NO = "NO",
  OM = "OM",
  PK = "PK",
  PW = "PW",
  PA = "PA",
  PG = "PG",
  PY = "PY",
  PE = "PE",
  PL = "PL",
  PT = "PT",
  QA = "QA",
  RO = "RO",
  RU = "RU",
  RW = "RW",
  LC = "LC",
  SV = "SV",
  WS = "WS",
  SM = "SM",
  ST = "ST",
  SA = "SA",
  SN = "SN",
  RS = "RS",
  SC = "SC",
  SL = "SL",
  SG = "SG",
  SK = "SK",
  SI = "SI",
  SB = "SB",
  SO = "SO",
  ZA = "ZA",
  KR = "KR",
  ES = "ES",
  LK = "LK",
  SD = "SD",
  SR = "SR",
  SZ = "SZ",
  SE = "SE",
  CH = "CH",
  SY = "SY",
  TW = "TW",
  TJ = "TJ",
  TZ = "TZ",
  TH = "TH",
  TG = "TG",
  TO = "TO",
  TT = "TT",
  TN = "TN",
  TR = "TR",
  TV = "TV",
  UG = "UG",
  UA = "UA",
  UY = "UY",
  UZ = "UZ",
  VE = "VE",
  VN = "VN",
  YE = "YE",
  ZM = "ZM",
  ZW = "ZW",
}

export const countryNamesByCode: { [c in CountryCode]: Translator } = {
  [CountryCode.AF]: (i18n) => i18n.str`Afghanistan`,
  [CountryCode.AL]: (i18n) => i18n.str`Albania`,
  [CountryCode.DZ]: (i18n) => i18n.str`Algeria`,
  [CountryCode.US]: (i18n) => i18n.str`United States`,
  [CountryCode.AD]: (i18n) => i18n.str`Andorra`,
  [CountryCode.AO]: (i18n) => i18n.str`Angola`,
  [CountryCode.AG]: (i18n) => i18n.str`Antigua and Barbuda`,
  [CountryCode.AR]: (i18n) => i18n.str`Argentina`,
  [CountryCode.AM]: (i18n) => i18n.str`Armenia`,
  [CountryCode.AU]: (i18n) => i18n.str`Australia`,
  [CountryCode.AT]: (i18n) => i18n.str`Austria`,
  [CountryCode.AZ]: (i18n) => i18n.str`Azerbaijan`,
  [CountryCode.BS]: (i18n) => i18n.str`Bahamas`,
  [CountryCode.BH]: (i18n) => i18n.str`Bahrain`,
  [CountryCode.BD]: (i18n) => i18n.str`Bangladesh`,
  [CountryCode.BB]: (i18n) => i18n.str`Barbados`,
  [CountryCode.BW]: (i18n) => i18n.str`Botswana`,
  [CountryCode.BY]: (i18n) => i18n.str`Belarus`,
  [CountryCode.BE]: (i18n) => i18n.str`Belgium`,
  [CountryCode.BZ]: (i18n) => i18n.str`Belize`,
  [CountryCode.BJ]: (i18n) => i18n.str`Benin`,
  [CountryCode.BT]: (i18n) => i18n.str`Bhutan`,
  [CountryCode.BO]: (i18n) => i18n.str`Bolivia`,
  [CountryCode.BA]: (i18n) => i18n.str`Bosnia and Herzegovina`,
  [CountryCode.BR]: (i18n) => i18n.str`Brazil`,
  [CountryCode.GB]: (i18n) => i18n.str`United Kingdom`,
  [CountryCode.BN]: (i18n) => i18n.str`Brunei`,
  [CountryCode.BG]: (i18n) => i18n.str`Bulgaria`,
  [CountryCode.BF]: (i18n) => i18n.str`Burkina Faso`,
  [CountryCode.MM]: (i18n) => i18n.str`Myanmar`,
  [CountryCode.BI]: (i18n) => i18n.str`Burundi`,
  [CountryCode.KH]: (i18n) => i18n.str`Cambodia`,
  [CountryCode.CM]: (i18n) => i18n.str`Cameroon`,
  [CountryCode.CA]: (i18n) => i18n.str`Canada`,
  [CountryCode.CV]: (i18n) => i18n.str`Cape Verde`,
  [CountryCode.CF]: (i18n) => i18n.str`Central African Republic`,
  [CountryCode.TD]: (i18n) => i18n.str`Chad`,
  [CountryCode.CL]: (i18n) => i18n.str`Chile`,
  [CountryCode.CN]: (i18n) => i18n.str`China`,
  [CountryCode.CO]: (i18n) => i18n.str`Colombia`,
  [CountryCode.KM]: (i18n) => i18n.str`Comoros`,
  [CountryCode.CD]: (i18n) => i18n.str`Democratic Republic of the Congo`,
  [CountryCode.CG]: (i18n) => i18n.str`Republic of the Congo`,
  [CountryCode.CR]: (i18n) => i18n.str`Costa Rica`,
  [CountryCode.HR]: (i18n) => i18n.str`Croatia`,
  [CountryCode.CU]: (i18n) => i18n.str`Cuba`,
  [CountryCode.CY]: (i18n) => i18n.str`Cyprus`,
  [CountryCode.CZ]: (i18n) => i18n.str`Czech Republic`,
  [CountryCode.DK]: (i18n) => i18n.str`Denmark`,
  [CountryCode.DJ]: (i18n) => i18n.str`Djibouti`,
  [CountryCode.DO]: (i18n) => i18n.str`Dominican Republic`,
  [CountryCode.NL]: (i18n) => i18n.str`Netherlands`,
  [CountryCode.TL]: (i18n) => i18n.str`Timor-Leste`,
  [CountryCode.EC]: (i18n) => i18n.str`Ecuador`,
  [CountryCode.EG]: (i18n) => i18n.str`Egypt`,
  [CountryCode.AE]: (i18n) => i18n.str`United Arab Emirates`,
  [CountryCode.GQ]: (i18n) => i18n.str`Equatorial Guinea`,
  [CountryCode.ER]: (i18n) => i18n.str`Eritrea`,
  [CountryCode.EE]: (i18n) => i18n.str`Estonia`,
  [CountryCode.ET]: (i18n) => i18n.str`Ethiopia`,
  [CountryCode.FJ]: (i18n) => i18n.str`Fiji`,
  [CountryCode.PH]: (i18n) => i18n.str`Philippines`,
  [CountryCode.FI]: (i18n) => i18n.str`Finland`,
  [CountryCode.FR]: (i18n) => i18n.str`France`,
  [CountryCode.GA]: (i18n) => i18n.str`Gabon`,
  [CountryCode.GM]: (i18n) => i18n.str`Gambia`,
  [CountryCode.GE]: (i18n) => i18n.str`Georgia`,
  [CountryCode.DE]: (i18n) => i18n.str`Germany`,
  [CountryCode.GH]: (i18n) => i18n.str`Ghana`,
  [CountryCode.GR]: (i18n) => i18n.str`Greece`,
  [CountryCode.GD]: (i18n) => i18n.str`Grenada`,
  [CountryCode.GT]: (i18n) => i18n.str`Guatemala`,
  [CountryCode.GW]: (i18n) => i18n.str`Guinea-Bissau`,
  [CountryCode.GN]: (i18n) => i18n.str`Guinea`,
  [CountryCode.GY]: (i18n) => i18n.str`Guyana`,
  [CountryCode.HT]: (i18n) => i18n.str`Haiti`,
  [CountryCode.HN]: (i18n) => i18n.str`Honduras`,
  [CountryCode.HU]: (i18n) => i18n.str`Hungary`,
  [CountryCode.KI]: (i18n) => i18n.str`Kiribati`,
  [CountryCode.IS]: (i18n) => i18n.str`Iceland`,
  [CountryCode.IN]: (i18n) => i18n.str`India`,
  [CountryCode.ID]: (i18n) => i18n.str`Indonesia`,
  [CountryCode.IR]: (i18n) => i18n.str`Iran`,
  [CountryCode.IQ]: (i18n) => i18n.str`Iraq`,
  [CountryCode.IE]: (i18n) => i18n.str`Ireland`,
  [CountryCode.IL]: (i18n) => i18n.str`Israel`,
  [CountryCode.IT]: (i18n) => i18n.str`Italy`,
  [CountryCode.CI]: (i18n) => i18n.str`Ivory Coast`,
  [CountryCode.JM]: (i18n) => i18n.str`Jamaica`,
  [CountryCode.JP]: (i18n) => i18n.str`Japan`,
  [CountryCode.JO]: (i18n) => i18n.str`Jordan`,
  [CountryCode.KZ]: (i18n) => i18n.str`Kazakhstan`,
  [CountryCode.KE]: (i18n) => i18n.str`Kenya`,
  [CountryCode.KN]: (i18n) => i18n.str`Saint Kitts and Nevis`,
  [CountryCode.KW]: (i18n) => i18n.str`Kuwait`,
  [CountryCode.KG]: (i18n) => i18n.str`Kyrgyzstan`,
  [CountryCode.LA]: (i18n) => i18n.str`Laos`,
  [CountryCode.LV]: (i18n) => i18n.str`Latvia`,
  [CountryCode.LB]: (i18n) => i18n.str`Lebanon`,
  [CountryCode.LR]: (i18n) => i18n.str`Liberia`,
  [CountryCode.LY]: (i18n) => i18n.str`Libya`,
  [CountryCode.LI]: (i18n) => i18n.str`Liechtenstein`,
  [CountryCode.LT]: (i18n) => i18n.str`Lithuania`,
  [CountryCode.LU]: (i18n) => i18n.str`Luxembourg`,
  [CountryCode.MK]: (i18n) => i18n.str`North Macedonia`,
  [CountryCode.MG]: (i18n) => i18n.str`Madagascar`,
  [CountryCode.MW]: (i18n) => i18n.str`Malawi`,
  [CountryCode.MY]: (i18n) => i18n.str`Malaysia`,
  [CountryCode.MV]: (i18n) => i18n.str`Maldives`,
  [CountryCode.ML]: (i18n) => i18n.str`Mali`,
  [CountryCode.MT]: (i18n) => i18n.str`Malta`,
  [CountryCode.MH]: (i18n) => i18n.str`Marshall Islands`,
  [CountryCode.MR]: (i18n) => i18n.str`Mauritania`,
  [CountryCode.MU]: (i18n) => i18n.str`Mauritius`,
  [CountryCode.MX]: (i18n) => i18n.str`Mexico`,
  [CountryCode.FM]: (i18n) => i18n.str`Micronesia`,
  [CountryCode.MD]: (i18n) => i18n.str`Moldova`,
  [CountryCode.MC]: (i18n) => i18n.str`Monaco`,
  [CountryCode.MN]: (i18n) => i18n.str`Mongolia`,
  [CountryCode.MA]: (i18n) => i18n.str`Morocco`,
  [CountryCode.LS]: (i18n) => i18n.str`Lesotho`,
  [CountryCode.MZ]: (i18n) => i18n.str`Mozambique`,
  [CountryCode.NA]: (i18n) => i18n.str`Namibia`,
  [CountryCode.NR]: (i18n) => i18n.str`Nauru`,
  [CountryCode.NP]: (i18n) => i18n.str`Nepal`,
  [CountryCode.NZ]: (i18n) => i18n.str`New Zealand`,
  [CountryCode.VU]: (i18n) => i18n.str`Vanuatu`,
  [CountryCode.NI]: (i18n) => i18n.str`Nicaragua`,
  [CountryCode.NG]: (i18n) => i18n.str`Nigeria`,
  [CountryCode.NE]: (i18n) => i18n.str`Niger`,
  [CountryCode.KP]: (i18n) => i18n.str`North Korea`,
  [CountryCode.NO]: (i18n) => i18n.str`Norway`,
  [CountryCode.OM]: (i18n) => i18n.str`Oman`,
  [CountryCode.PK]: (i18n) => i18n.str`Pakistan`,
  [CountryCode.PW]: (i18n) => i18n.str`Palau`,
  [CountryCode.PA]: (i18n) => i18n.str`Panama`,
  [CountryCode.PG]: (i18n) => i18n.str`Papua New Guinea`,
  [CountryCode.PY]: (i18n) => i18n.str`Paraguay`,
  [CountryCode.PE]: (i18n) => i18n.str`Peru`,
  [CountryCode.PL]: (i18n) => i18n.str`Poland`,
  [CountryCode.PT]: (i18n) => i18n.str`Portugal`,
  [CountryCode.QA]: (i18n) => i18n.str`Qatar`,
  [CountryCode.RO]: (i18n) => i18n.str`Romania`,
  [CountryCode.RU]: (i18n) => i18n.str`Russia`,
  [CountryCode.RW]: (i18n) => i18n.str`Rwanda`,
  [CountryCode.LC]: (i18n) => i18n.str`Saint Lucia`,
  [CountryCode.SV]: (i18n) => i18n.str`El Salvador`,
  [CountryCode.WS]: (i18n) => i18n.str`Samoa`,
  [CountryCode.SM]: (i18n) => i18n.str`San Marino`,
  [CountryCode.ST]: (i18n) => i18n.str`São Tomé and Príncipe`,
  [CountryCode.SA]: (i18n) => i18n.str`Saudi Arabia`,
  [CountryCode.SN]: (i18n) => i18n.str`Senegal`,
  [CountryCode.RS]: (i18n) => i18n.str`Serbia`,
  [CountryCode.SC]: (i18n) => i18n.str`Seychelles`,
  [CountryCode.SL]: (i18n) => i18n.str`Sierra Leone`,
  [CountryCode.SG]: (i18n) => i18n.str`Singapore`,
  [CountryCode.SK]: (i18n) => i18n.str`Slovakia`,
  [CountryCode.SI]: (i18n) => i18n.str`Slovenia`,
  [CountryCode.SB]: (i18n) => i18n.str`Solomon Islands`,
  [CountryCode.SO]: (i18n) => i18n.str`Somalia`,
  [CountryCode.ZA]: (i18n) => i18n.str`South Africa`,
  [CountryCode.KR]: (i18n) => i18n.str`South Korea`,
  [CountryCode.ES]: (i18n) => i18n.str`Spain`,
  [CountryCode.LK]: (i18n) => i18n.str`Sri Lanka`,
  [CountryCode.SD]: (i18n) => i18n.str`Sudan`,
  [CountryCode.SR]: (i18n) => i18n.str`Suriname`,
  [CountryCode.SZ]: (i18n) => i18n.str`Eswatini`,
  [CountryCode.SE]: (i18n) => i18n.str`Sweden`,
  [CountryCode.CH]: (i18n) => i18n.str`Switzerland`,
  [CountryCode.SY]: (i18n) => i18n.str`Syria`,
  [CountryCode.TW]: (i18n) => i18n.str`Taiwan`,
  [CountryCode.TJ]: (i18n) => i18n.str`Tajikistan`,
  [CountryCode.TZ]: (i18n) => i18n.str`Tanzania`,
  [CountryCode.TH]: (i18n) => i18n.str`Thailand`,
  [CountryCode.TG]: (i18n) => i18n.str`Togo`,
  [CountryCode.TO]: (i18n) => i18n.str`Tonga`,
  [CountryCode.TT]: (i18n) => i18n.str`Trinidad and Tobago`,
  [CountryCode.TN]: (i18n) => i18n.str`Tunisia`,
  [CountryCode.TR]: (i18n) => i18n.str`Turkey`,
  [CountryCode.TV]: (i18n) => i18n.str`Tuvalu`,
  [CountryCode.UG]: (i18n) => i18n.str`Uganda`,
  [CountryCode.UA]: (i18n) => i18n.str`Ukraine`,
  [CountryCode.UY]: (i18n) => i18n.str`Uruguay`,
  [CountryCode.UZ]: (i18n) => i18n.str`Uzbekistan`,
  [CountryCode.VE]: (i18n) => i18n.str`Venezuela`,
  [CountryCode.VN]: (i18n) => i18n.str`Vietnam`,
  [CountryCode.YE]: (i18n) => i18n.str`Yemen`,
  [CountryCode.ZM]: (i18n) => i18n.str`Zambia`,
  [CountryCode.ZW]: (i18n) => i18n.str`Zimbabwe`,
};

export const countryNationalitiesByCode: { [c in CountryCode]: Translator } = {
  [CountryCode.AF]: (i18n) => i18n.str`Afghan`,
  [CountryCode.AL]: (i18n) => i18n.str`Albanian`,
  [CountryCode.DZ]: (i18n) => i18n.str`Algerian`,
  [CountryCode.US]: (i18n) => i18n.str`American`,
  [CountryCode.AD]: (i18n) => i18n.str`Andorran`,
  [CountryCode.AO]: (i18n) => i18n.str`Angolan`,
  [CountryCode.AG]: (i18n) => i18n.str`Antiguan`,
  [CountryCode.AR]: (i18n) => i18n.str`Argentinean`,
  [CountryCode.AM]: (i18n) => i18n.str`Armenian`,
  [CountryCode.AU]: (i18n) => i18n.str`Australian`,
  [CountryCode.AT]: (i18n) => i18n.str`Austrian`,
  [CountryCode.AZ]: (i18n) => i18n.str`Azerbaijani`,
  [CountryCode.BS]: (i18n) => i18n.str`Bahamian`,
  [CountryCode.BH]: (i18n) => i18n.str`Bahraini`,
  [CountryCode.BD]: (i18n) => i18n.str`Bangladeshi`,
  [CountryCode.BB]: (i18n) => i18n.str`Barbadian`,
  [CountryCode.BW]: (i18n) => i18n.str`Batswana`,
  [CountryCode.BY]: (i18n) => i18n.str`Belarusian`,
  [CountryCode.BE]: (i18n) => i18n.str`Belgian`,
  [CountryCode.BZ]: (i18n) => i18n.str`Belizean`,
  [CountryCode.BJ]: (i18n) => i18n.str`Beninese`,
  [CountryCode.BT]: (i18n) => i18n.str`Bhutanese`,
  [CountryCode.BO]: (i18n) => i18n.str`Bolivian`,
  [CountryCode.BA]: (i18n) => i18n.str`Bosnian`,
  [CountryCode.BR]: (i18n) => i18n.str`Brazilian`,
  [CountryCode.GB]: (i18n) => i18n.str`British`,
  [CountryCode.BN]: (i18n) => i18n.str`Bruneian`,
  [CountryCode.BG]: (i18n) => i18n.str`Bulgarian`,
  [CountryCode.BF]: (i18n) => i18n.str`Burkinabe`,
  [CountryCode.MM]: (i18n) => i18n.str`Burmese`,
  [CountryCode.BI]: (i18n) => i18n.str`Burundian`,
  [CountryCode.KH]: (i18n) => i18n.str`Cambodian`,
  [CountryCode.CM]: (i18n) => i18n.str`Cameroonian`,
  [CountryCode.CA]: (i18n) => i18n.str`Canadian`,
  [CountryCode.CV]: (i18n) => i18n.str`Cape Verdean`,
  [CountryCode.CF]: (i18n) => i18n.str`Central African`,
  [CountryCode.TD]: (i18n) => i18n.str`Chadian`,
  [CountryCode.CL]: (i18n) => i18n.str`Chilean`,
  [CountryCode.CN]: (i18n) => i18n.str`Chinese`,
  [CountryCode.CO]: (i18n) => i18n.str`Colombian`,
  [CountryCode.KM]: (i18n) => i18n.str`Comoran`,
  [CountryCode.CD]: (i18n) => i18n.str`Congolese`,
  [CountryCode.CG]: (i18n) => i18n.str`Congolese`,
  [CountryCode.CR]: (i18n) => i18n.str`Costa Rican`,
  [CountryCode.HR]: (i18n) => i18n.str`Croatian`,
  [CountryCode.CU]: (i18n) => i18n.str`Cuban`,
  [CountryCode.CY]: (i18n) => i18n.str`Cypriot`,
  [CountryCode.CZ]: (i18n) => i18n.str`Czech`,
  [CountryCode.DK]: (i18n) => i18n.str`Danish`,
  [CountryCode.DJ]: (i18n) => i18n.str`Djiboutian`,
  [CountryCode.DO]: (i18n) => i18n.str`Dominican`,
  [CountryCode.NL]: (i18n) => i18n.str`Dutch`,
  [CountryCode.TL]: (i18n) => i18n.str`East Timorese`,
  [CountryCode.EC]: (i18n) => i18n.str`Ecuadorean`,
  [CountryCode.EG]: (i18n) => i18n.str`Egyptian`,
  [CountryCode.AE]: (i18n) => i18n.str`Emirati`,
  [CountryCode.GQ]: (i18n) => i18n.str`Equatorial Guinean`,
  [CountryCode.ER]: (i18n) => i18n.str`Eritrean`,
  [CountryCode.EE]: (i18n) => i18n.str`Estonian`,
  [CountryCode.ET]: (i18n) => i18n.str`Ethiopian`,
  [CountryCode.FJ]: (i18n) => i18n.str`Fijian`,
  [CountryCode.PH]: (i18n) => i18n.str`Filipino`,
  [CountryCode.FI]: (i18n) => i18n.str`Finnish`,
  [CountryCode.FR]: (i18n) => i18n.str`French`,
  [CountryCode.GA]: (i18n) => i18n.str`Gabonese`,
  [CountryCode.GM]: (i18n) => i18n.str`Gambian`,
  [CountryCode.GE]: (i18n) => i18n.str`Georgian`,
  [CountryCode.DE]: (i18n) => i18n.str`German`,
  [CountryCode.GH]: (i18n) => i18n.str`Ghanaian`,
  [CountryCode.GR]: (i18n) => i18n.str`Greek`,
  [CountryCode.GD]: (i18n) => i18n.str`Grenadian`,
  [CountryCode.GT]: (i18n) => i18n.str`Guatemalan`,
  [CountryCode.GW]: (i18n) => i18n.str`Guinea-Bissauan`,
  [CountryCode.GN]: (i18n) => i18n.str`Guinean`,
  [CountryCode.GY]: (i18n) => i18n.str`Guyanese`,
  [CountryCode.HT]: (i18n) => i18n.str`Haitian`,
  [CountryCode.HN]: (i18n) => i18n.str`Honduran`,
  [CountryCode.HU]: (i18n) => i18n.str`Hungarian`,
  [CountryCode.KI]: (i18n) => i18n.str`I-Kiribati`,
  [CountryCode.IS]: (i18n) => i18n.str`Icelander`,
  [CountryCode.IN]: (i18n) => i18n.str`Indian`,
  [CountryCode.ID]: (i18n) => i18n.str`Indonesian`,
  [CountryCode.IR]: (i18n) => i18n.str`Iranian`,
  [CountryCode.IQ]: (i18n) => i18n.str`Iraqi`,
  [CountryCode.IE]: (i18n) => i18n.str`Irish`,
  [CountryCode.IL]: (i18n) => i18n.str`Israeli`,
  [CountryCode.IT]: (i18n) => i18n.str`Italian`,
  [CountryCode.CI]: (i18n) => i18n.str`Ivorian`,
  [CountryCode.JM]: (i18n) => i18n.str`Jamaican`,
  [CountryCode.JP]: (i18n) => i18n.str`Japanese`,
  [CountryCode.JO]: (i18n) => i18n.str`Jordanian`,
  [CountryCode.KZ]: (i18n) => i18n.str`Kazakhstani`,
  [CountryCode.KE]: (i18n) => i18n.str`Kenyan`,
  [CountryCode.KN]: (i18n) => i18n.str`Kittian and Nevisian`,
  [CountryCode.KW]: (i18n) => i18n.str`Kuwaiti`,
  [CountryCode.KG]: (i18n) => i18n.str`Kyrgyz`,
  [CountryCode.LA]: (i18n) => i18n.str`Laotian`,
  [CountryCode.LV]: (i18n) => i18n.str`Latvian`,
  [CountryCode.LB]: (i18n) => i18n.str`Lebanese`,
  [CountryCode.LR]: (i18n) => i18n.str`Liberian`,
  [CountryCode.LY]: (i18n) => i18n.str`Libyan`,
  [CountryCode.LI]: (i18n) => i18n.str`Liechtensteiner`,
  [CountryCode.LT]: (i18n) => i18n.str`Lithuanian`,
  [CountryCode.LU]: (i18n) => i18n.str`Luxembourger`,
  [CountryCode.MK]: (i18n) => i18n.str`Macedonian`,
  [CountryCode.MG]: (i18n) => i18n.str`Malagasy`,
  [CountryCode.MW]: (i18n) => i18n.str`Malawian`,
  [CountryCode.MY]: (i18n) => i18n.str`Malaysian`,
  [CountryCode.MV]: (i18n) => i18n.str`Maldivian`,
  [CountryCode.ML]: (i18n) => i18n.str`Malian`,
  [CountryCode.MT]: (i18n) => i18n.str`Maltese`,
  [CountryCode.MH]: (i18n) => i18n.str`Marshallese`,
  [CountryCode.MR]: (i18n) => i18n.str`Mauritanian`,
  [CountryCode.MU]: (i18n) => i18n.str`Mauritian`,
  [CountryCode.MX]: (i18n) => i18n.str`Mexican`,
  [CountryCode.FM]: (i18n) => i18n.str`Micronesian`,
  [CountryCode.MD]: (i18n) => i18n.str`Moldovan`,
  [CountryCode.MC]: (i18n) => i18n.str`Monacan`,
  [CountryCode.MN]: (i18n) => i18n.str`Mongolian`,
  [CountryCode.MA]: (i18n) => i18n.str`Moroccan`,
  [CountryCode.LS]: (i18n) => i18n.str`Mosotho`,
  [CountryCode.MZ]: (i18n) => i18n.str`Mozambican`,
  [CountryCode.NA]: (i18n) => i18n.str`Namibian`,
  [CountryCode.NR]: (i18n) => i18n.str`Nauruan`,
  [CountryCode.NP]: (i18n) => i18n.str`Nepalese`,
  [CountryCode.NZ]: (i18n) => i18n.str`New Zealander`,
  [CountryCode.VU]: (i18n) => i18n.str`Ni-Vanuatu`,
  [CountryCode.NI]: (i18n) => i18n.str`Nicaraguan`,
  [CountryCode.NG]: (i18n) => i18n.str`Nigerian`,
  [CountryCode.NE]: (i18n) => i18n.str`Nigerien`,
  [CountryCode.KP]: (i18n) => i18n.str`North Korean`,
  [CountryCode.NO]: (i18n) => i18n.str`Norwegian`,
  [CountryCode.OM]: (i18n) => i18n.str`Omani`,
  [CountryCode.PK]: (i18n) => i18n.str`Pakistani`,
  [CountryCode.PW]: (i18n) => i18n.str`Palauan`,
  [CountryCode.PA]: (i18n) => i18n.str`Panamanian`,
  [CountryCode.PG]: (i18n) => i18n.str`Papua New Guinean`,
  [CountryCode.PY]: (i18n) => i18n.str`Paraguayan`,
  [CountryCode.PE]: (i18n) => i18n.str`Peruvian`,
  [CountryCode.PL]: (i18n) => i18n.str`Polish`,
  [CountryCode.PT]: (i18n) => i18n.str`Portuguese`,
  [CountryCode.QA]: (i18n) => i18n.str`Qatari`,
  [CountryCode.RO]: (i18n) => i18n.str`Romanian`,
  [CountryCode.RU]: (i18n) => i18n.str`Russian`,
  [CountryCode.RW]: (i18n) => i18n.str`Rwandan`,
  [CountryCode.LC]: (i18n) => i18n.str`Saint Lucian`,
  [CountryCode.SV]: (i18n) => i18n.str`Salvadoran`,
  [CountryCode.WS]: (i18n) => i18n.str`Samoan`,
  [CountryCode.SM]: (i18n) => i18n.str`San Marinese`,
  [CountryCode.ST]: (i18n) => i18n.str`Sao Tomean`,
  [CountryCode.SA]: (i18n) => i18n.str`Saudi`,
  [CountryCode.SN]: (i18n) => i18n.str`Senegalese`,
  [CountryCode.RS]: (i18n) => i18n.str`Serbian`,
  [CountryCode.SC]: (i18n) => i18n.str`Seychellois`,
  [CountryCode.SL]: (i18n) => i18n.str`Sierra Leonean`,
  [CountryCode.SG]: (i18n) => i18n.str`Singaporean`,
  [CountryCode.SK]: (i18n) => i18n.str`Slovakian`,
  [CountryCode.SI]: (i18n) => i18n.str`Slovenian`,
  [CountryCode.SB]: (i18n) => i18n.str`Solomon Islander`,
  [CountryCode.SO]: (i18n) => i18n.str`Somali`,
  [CountryCode.ZA]: (i18n) => i18n.str`South African`,
  [CountryCode.KR]: (i18n) => i18n.str`South Korean`,
  [CountryCode.ES]: (i18n) => i18n.str`Spanish`,
  [CountryCode.LK]: (i18n) => i18n.str`Sri Lankan`,
  [CountryCode.SD]: (i18n) => i18n.str`Sudanese`,
  [CountryCode.SR]: (i18n) => i18n.str`Surinamer`,
  [CountryCode.SZ]: (i18n) => i18n.str`Swazi`,
  [CountryCode.SE]: (i18n) => i18n.str`Swedish`,
  [CountryCode.CH]: (i18n) => i18n.str`Swiss`,
  [CountryCode.SY]: (i18n) => i18n.str`Syrian`,
  [CountryCode.TW]: (i18n) => i18n.str`Taiwanese`,
  [CountryCode.TJ]: (i18n) => i18n.str`Tajik`,
  [CountryCode.TZ]: (i18n) => i18n.str`Tanzanian`,
  [CountryCode.TH]: (i18n) => i18n.str`Thai`,
  [CountryCode.TG]: (i18n) => i18n.str`Togolese`,
  [CountryCode.TO]: (i18n) => i18n.str`Tongan`,
  [CountryCode.TT]: (i18n) => i18n.str`Trinidadian or Tobagonian`,
  [CountryCode.TN]: (i18n) => i18n.str`Tunisian`,
  [CountryCode.TR]: (i18n) => i18n.str`Turkish`,
  [CountryCode.TV]: (i18n) => i18n.str`Tuvaluan`,
  [CountryCode.UG]: (i18n) => i18n.str`Ugandan`,
  [CountryCode.UA]: (i18n) => i18n.str`Ukrainian`,
  [CountryCode.UY]: (i18n) => i18n.str`Uruguayan`,
  [CountryCode.UZ]: (i18n) => i18n.str`Uzbekistani`,
  [CountryCode.VE]: (i18n) => i18n.str`Venezuelan`,
  [CountryCode.VN]: (i18n) => i18n.str`Vietnamese`,
  [CountryCode.YE]: (i18n) => i18n.str`Yemenite`,
  [CountryCode.ZM]: (i18n) => i18n.str`Zambian`,
  [CountryCode.ZW]: (i18n) => i18n.str`Zimbabwean`,
};

export const countriesUnicodeFlagByCode: { [c in CountryCode]?: Translator } = {
  [CountryCode.AF]: (i18n) => i18n.str`\ud83c\udde6\ud83c\uddeb`,
  [CountryCode.AL]: (i18n) => i18n.str`\ud83c\udde6\ud83c\uddf1`,
  [CountryCode.DZ]: (i18n) => i18n.str`\ud83c\udde9\ud83c\uddff`,
  [CountryCode.US]: (i18n) => i18n.str`\ud83c\uddfa\ud83c\uddf8`,
  [CountryCode.AD]: (i18n) => i18n.str`\ud83c\udde6\ud83c\udde9`,
  [CountryCode.AO]: (i18n) => i18n.str`\ud83c\udde6\ud83c\uddf4`,
  [CountryCode.AG]: (i18n) => i18n.str`\ud83c\udde6\ud83c\uddec`,
  [CountryCode.AR]: (i18n) => i18n.str`\ud83c\udde6\ud83c\uddf7`,
  [CountryCode.AM]: (i18n) => i18n.str`\ud83c\udde6\ud83c\uddf2`,
  [CountryCode.AU]: (i18n) => i18n.str`\ud83c\udde6\ud83c\uddfa`,
  [CountryCode.AT]: (i18n) => i18n.str`\ud83c\udde6\ud83c\uddf9`,
  [CountryCode.AZ]: (i18n) => i18n.str`\ud83c\udde6\ud83c\uddff`,
  [CountryCode.BS]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddf8`,
  [CountryCode.BH]: (i18n) => i18n.str`\ud83c\udde7\ud83c\udded`,
  [CountryCode.BD]: (i18n) => i18n.str`\ud83c\udde7\ud83c\udde9`,
  [CountryCode.BB]: (i18n) => i18n.str`\ud83c\udde7\ud83c\udde7`,
  [CountryCode.BW]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddfc`,
  [CountryCode.BY]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddfe`,
  [CountryCode.BE]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddea`,
  [CountryCode.BZ]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddff`,
  [CountryCode.BJ]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddef`,
  [CountryCode.BT]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddf9`,
  [CountryCode.BO]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddf4`,
  [CountryCode.BA]: (i18n) => i18n.str`\ud83c\udde7\ud83c\udde6`,
  [CountryCode.BR]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddf7`,
  [CountryCode.GB]: (i18n) => i18n.str`\ud83c\uddec\ud83c\udde7`,
  [CountryCode.BN]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddf3`,
  [CountryCode.BG]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddec`,
  [CountryCode.BF]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddeb`,
  [CountryCode.MM]: (i18n) => i18n.str`\ud83c\uddf2\ud83c\uddf2`,
  [CountryCode.BI]: (i18n) => i18n.str`\ud83c\udde7\ud83c\uddee`,
  [CountryCode.KH]: (i18n) => i18n.str`\ud83c\uddf0\ud83c\udded`,
  [CountryCode.CM]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddf2`,
  [CountryCode.CA]: (i18n) => i18n.str`\ud83c\udde8\ud83c\udde6`,
  [CountryCode.CV]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddfb`,
  [CountryCode.CF]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddeb`,
  [CountryCode.TD]: (i18n) => i18n.str`\ud83c\udde9\ud83c\uddff`,
  [CountryCode.CL]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddf1`,
  [CountryCode.CN]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddf3`,
  [CountryCode.CO]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddf4`,
  [CountryCode.KM]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddf2`,
  [CountryCode.CD]: (i18n) => i18n.str`\ud83c\udde8\ud83c\udde9`,
  [CountryCode.CG]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddec`,
  [CountryCode.CR]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddf7`,
  [CountryCode.HR]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddfb`,
  [CountryCode.CU]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddfa`,
  [CountryCode.CY]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddfe`,
  [CountryCode.CZ]: (i18n) => i18n.str`\ud83c\udde8\ud83c\uddff`,
  [CountryCode.DK]: (i18n) => i18n.str`\ud83c\udde9\ud83c\uddf0`,
  [CountryCode.DJ]: (i18n) => i18n.str`\ud83c\udde9\ud83c\uddef`,
  [CountryCode.DO]: (i18n) => i18n.str`\ud83c\udde9\ud83c\uddf4`,
  [CountryCode.NL]: (i18n) => i18n.str`\ud83c\uddf3\ud83c\uddf1`,
  [CountryCode.TL]: (i18n) => i18n.str`\ud83c\uddf9\ud83c\uddf1`,
  [CountryCode.EC]: (i18n) => i18n.str`\ud83c\uddea\ud83c\udde8`,
  [CountryCode.EG]: (i18n) => i18n.str`\ud83c\uddea\ud83c\uddec`,
  [CountryCode.AE]: (i18n) => i18n.str`\ud83c\udde6\ud83c\uddea`,
  [CountryCode.GQ]: (i18n) => i18n.str`\ud83c\uddec\ud83c\uddf6`,
  [CountryCode.ER]: (i18n) => i18n.str`\ud83c\uddea\ud83c\uddf7`,
  [CountryCode.EE]: (i18n) => i18n.str`\ud83c\uddea\ud83c\uddea`,
  [CountryCode.ET]: (i18n) => i18n.str`\ud83c\uddea\ud83c\uddf9`,
  [CountryCode.FJ]: (i18n) => i18n.str`\ud83c\uddeb\ud83c\uddef`,
  [CountryCode.PH]: (i18n) => i18n.str`\ud83c\uddf5\ud83c\udded`,
  [CountryCode.FI]: (i18n) => i18n.str`\ud83c\uddeb\ud83c\uddee`,
  [CountryCode.FR]: (i18n) => i18n.str`\ud83c\uddeb\ud83c\uddf7`,
  [CountryCode.GA]: (i18n) => i18n.str`\ud83c\uddec\ud83c\udde6`,
  [CountryCode.GM]: (i18n) => i18n.str`\ud83c\uddec\ud83c\uddf2`,
  [CountryCode.GE]: (i18n) => i18n.str`\ud83c\uddec\ud83c\uddea`,
};
