/*
 This file is part of GNU Taler
 (C) 2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import test, { ExecutionContext } from "ava";
import { deserializeKey, serializeKey } from "./key-storage.js";
import { IDBValidKey } from "../idbtypes.js";

function checkKeySer(t: ExecutionContext, k: IDBValidKey): void {
  const keyEnc = serializeKey(k);
  const keyDec = deserializeKey(keyEnc);
  t.deepEqual(k, keyDec);
}

test("basics", (t) => {
  checkKeySer(t, "foo");
  checkKeySer(t, "foo\0bar");
  checkKeySer(t, "foo\u1000bar");
  checkKeySer(t, "foo\u2000bar");
  checkKeySer(t, "foo\u5000bar");
  checkKeySer(t, "foo\uffffbar");
  checkKeySer(t, 42);
  checkKeySer(t, 255);
  checkKeySer(t, 254);
  checkKeySer(t, [1, 2, 3, 4]);
  checkKeySer(t, [[[1], 3], [4]]);
});
