
/*
 * Parse the configuration from the given filename if not NULL or stdin
 * otherwise.
 * returns:
 *  0 on success
 *  1 on failure
 */
int
verify_parse_configuration(const char *filename) {
	FILE *config_stream;
	struct stat sb;
    int result = 1;

    if (filename != NULL)
    {
        config_stream = fopen(filename, "r");
        if (config_stream == NULL)
                ns_panic(ns_log_parser, 0, "can't open '%s'", filename);
        if (fstat(fileno(config_stream), &sb) == -1)
                ns_panic(ns_log_parser, 0, "can't stat '%s'", filename);
    }
    else
    {
        filename = "<stdin>";
        config_stream = stdin;
    }
        
	lexer_setup();
	parser_setup();
	lexer_begin_file(filename, config_stream);
	result = yyparse();
	lexer_end_file();
	parser_cleanup();
	return (result);
}


