#!/bin/sh
#
# Copyright (C) Internet Systems Consortium, Inc. ("ISC")
#
# Permission to use, copy, modify, and/or distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND ISC DISCLAIMS ALL WARRANTIES WITH
# REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS.  IN NO EVENT SHALL ISC BE LIABLE FOR ANY SPECIAL, DIRECT,
# INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
# LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
# OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
# PERFORMANCE OF THIS SOFTWARE.

SYSTEMTESTTOP=..
. $SYSTEMTESTTOP/conf.sh

status=0

echo_i "test name to long"
$PERL formerr.pl -a 10.53.0.1 -p ${PORT} nametoolong > nametoolong.out
ans=`grep got: nametoolong.out`
if [ "${ans}" != "got: 000080010000000000000000" ];
then
	echo_i "failed"; status=`expr $status + 1`;
fi

echo_i "two questions"
$PERL formerr.pl -a 10.53.0.1 -p ${PORT} twoquestions > twoquestions.out
ans=`grep got: twoquestions.out`
if [ "${ans}" != "got: 000080010000000000000000" ];
then
	echo_i "failed"; status=`expr $status + 1`;
fi

# this one arguable could be NOERORR.
echo_i "no questions"
$PERL formerr.pl -a 10.53.0.1 -p ${PORT} noquestions > noquestions.out
ans=`grep got: noquestions.out`
if [ "${ans}" != "got: 000080010000000000000000" ];
then
	echo_i "failed"; status=`expr $status + 1`;
fi

echo_i "bad OPT option"
$PERL formerr.pl -a 10.53.0.1 -p ${PORT} badoptoption > badoptoption.out
ans=`grep got: badoptoption.out`
if [ "${ans}" != "got: 00008001000100000000000100000100020000291000000000000000" ];
then
	echo_i "failed"; status=`expr $status + 1`;
fi

echo_i "exit status: $status"
[ $status -eq 0 ] || exit 1
