#include <stdio.h>

#include <qpopupmenu.h>
#include <qkeycode.h>

#include <kmenubar.h>
#include <ktoolbar.h>
#include <kiconloader.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kapp.h>

#include "kcustomactions.moc"

//Widget IDs for URLToolBar
const int URLLabel =0,
          URLCombo=1;
KCustomActions::KCustomActions (const char *name)
{
  new KAction ("Specia&l", CTRL+Key_L, 0L, 0L, actionCollection(), "special");
  KStdAction::quit (kapp, SLOT(closeAllWindows()), actionCollection());

  KStdAction::home (0L, 0L, actionCollection());

  new KAction ("My &Entry", 0,
               this, SLOT (slotMyEntry()), actionCollection(),
               "my_entry");
 
  checkable = new KToggleAction ("My Checkable Entry", 0,
                                 actionCollection(), "my_checkable_entry");
 
  KAction *grayentry =
    new KAction ( "My &Gray Entry", QIconSet (BarIcon("flag")),
		  0, 0L, 0L, actionCollection(),
                  "my_gray_entry" );
  grayentry->setEnabled (false);

  //Create toolbox.

  rectangle =
    new KRadioAction ("Rectangle select", 
		      QIconSet(BarIcon("rectangle_select")), 0,
		      this, SLOT (slotRectangle()),
		      actionCollection(), "rectangle");
  rectangle->setExclusiveGroup ("tools");

  pencil =
    new KRadioAction ("Pencil", 
		      QIconSet(BarIcon("pencil")), 0,
		      this, SLOT (slotPencil()),
		      actionCollection(), "pencil");
  pencil->setExclusiveGroup ("tools");

  rectangle->setChecked(true);
  
  createGUI("kcustomactionsui.rc");

  toolBar("toolBoxToolBar")->setBarPos (KToolBar::Left);
  toolBar("toolBoxToolBar")->setFullSize();


  //Create URL tool bar.

  QLabel *label = new QLabel ("URL:", toolBar("URLToolBar"));

  toolBar("URLToolBar")->
    insertWidget (URLLabel, label->sizeHint().width(), label);

  toolBar("URLToolBar")->
    insertCombo (QString("http://www.kde.org"),
		 URLCombo, true,
		 SIGNAL (activated (const QString &)),
		 this, SLOT (slotLoadPage (const QString &)));

  toolBar("URLToolBar")->setFullSize();
  toolBar("URLToolBar")->setItemAutoSized (URLCombo);
  


  QLabel *dummyclientarea = new QLabel (this);
  dummyclientarea->setBackgroundColor (Qt::white);

  // KMainWindow doesn't require or even have such a call,
  //  as KTMainWindow did.
  //  setView (dummyclientarea);

}

void
KCustomActions::slotMyEntry()
{
  printf ("Custom->My Entry\n");
}

void
KCustomActions::slotLoadPage(const QString &url)
{
  printf ("Load page: [%s]\n", (const char *)url);
}

void
KCustomActions::slotRectangle ()
{
  if (rectangle->isChecked())
    printf ("Use rectangle select tool\n");
}

void
KCustomActions::slotPencil ()
{
  if (pencil->isChecked())
    printf ("Use pencil select tool\n");
}
