#ifndef __KQUICKDRAW_H__
#define __KQUICKDRAW_H__


#include <qwidget.h>

class QPixmap;
class QTimer;

const int NEllipses=50000;

/**
 * KLongDraw
 * Handle long drawing job while keeping UI alive.
 **/
class KLongDraw : public QWidget
{
 Q_OBJECT

 public:
  KLongDraw (QWidget *parent, const char *name=0);

  protected slots:
    /**
     * Redraw some of the scene then exit and check the UI.
     **/
    void slotDrawSome();

 protected:
  /**
   * Repaint the window using a bit-block transfer from the
   *  off-screen buffer (a QPixmap).  Recreate the pixmap first,
   *  if necessary.
   **/
  void paintEvent (QPaintEvent *);

  void resizeEvent (QResizeEvent *);

 private:
  QTimer *qtimer;
  QPixmap *qpixmap;
  bool bneedrecreate;
  double x[NEllipses], y[NEllipses];
  int w, h;
  int total;
};

#endif
