#ifndef __KXOSQUARE_H__
#define __KXOSQUARE_H__


#include <qwidget.h>
#include <qsize.h>

/**
 * KXOSquare
 * Draws a square in one of three state: empty, with an X inside,
 *  or with an O inside.
 **/
class KXOSquare : public QWidget
{
 Q_OBJECT

 public:
  enum State {None=0, X=1, O=2};

  /**
   * Create the widget.
   **/
  KXOSquare (QWidget *parent, const char *name=0);

  /**
   * Chapter 4, Exercise 2
   * Return a recommended size for this widget.
   **/
  QSize sizeHint() const;

  public slots:
  /**
   * Change the state of the widget to <i>state</i>.
   **/
    void newState (State state);

 signals:
  /**
   * The user has requested that the state be changed to <i>state</i>
   *  by clicking on the square.
   **/
    void changeRequest (KXOSquare *, KXOSquare::State state);

 protected:
    /**
     * Draw the widget.
     **/
    void paintEvent (QPaintEvent *);

    /**
     * Process mouse clicks.
     **/
    void mousePressEvent (QMouseEvent *);

 private:
  State thestate;
};

#endif
