<?php
/*
 * $Horde: imp/redirect.php,v 1.23.2.20 2004/03/26 22:43:24 jan Exp $
 *
 * Copyright 1999-2004 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2004 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Get the initial URL.
 *
 * @param integer $actionID  The action ID to perform on the initial page.
 *
 * @return string  The initial URL.
 */
function _getInitialUrl($actionID)
{
    global $prefs;

    $url = $prefs->getValue('initial_page');
    if ($url != 'folders.php') {
        $url = 'mailbox.php';
        $url = IMP::addParameter($url, 'actionID=' . $actionID);
        $url = IMP::addParameter($url, 'mailbox=' . urlencode(IMP::addPreambleString($prefs->getValue('initial_page'))));
        $url = IMP::addParameter($url, IMP::getComposeArgs());
    }

    return Horde::applicationUrl($url, true);
}


@define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';


if (Horde::getFormData('action') == 'compose') {
    $actionID = LOGIN_COMPOSE;
} else {
    $actionID = Horde::getFormData('actionID', IMP_LOGIN);
}

$imapuser = Horde::getFormData('imapuser');
$pass = Horde::getFormData('pass');

/* If we already have a session... */
if (array_key_exists('imp', $_SESSION) && is_array($_SESSION['imp'])) {
    /* Make sure that if a username was specified, it is the current username */
    if ((is_null($imapuser) || ($imapuser == $_SESSION['imp']['user'])) &&
        (is_null($pass) || ($pass == Secret::read(Secret::getKey('imp'), $_SESSION['imp']['pass'])))) {

        $imp = &$_SESSION['imp'];
        if (!empty($_SESSION['imp']['_login'])) {
            IMP::authenticate(OP_HALFOPEN);
            IMP::loginTasks();
        }

        if ($actionID == IMP_LOGIN) {
            $actionID = null;
        }

        header('Location: ' . _getInitialUrl($actionID));
        exit;
    } else {
        /* Disable the old session. */
        $imp = false;
        session_unregister('imp');
        header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', 'failed'), true));
        exit;
    }
}

/* Create a new session if we're given the proper parameters. */
if (!is_null($imapuser) && !is_null($pass)) {
    if (!Horde::getFormData('mailbox')) {
        $_POST['mailbox'] = 'INBOX';
    }

    /* Destroy any existing session on login and make sure to use
       a new session ID, to avoid session fixation issues.
       This requires Horde 2.2.4 or higher. */
    if (in_array('getcleansession', get_class_methods('Horde')) &&
        ($registry->getMethod('auth/login') == 'imp')) {
        Horde::getCleanSession();
    }

    if (($reason = IMP::createSession()) === true) {
        $imp['_login'] = true;
        $entry = sprintf('Login success for %s [%s] to {%s:%s}', $imp['uniquser'], $_SERVER['REMOTE_ADDR'], $imp['server'], $imp['port']);
        Horde::logMessage($entry, __FILE__, __LINE__, LOG_NOTICE);

        if (($horde_language = Horde::getFormData('new_lang'))) {
            $_SESSION['horde_language'] = $horde_language;
        }

        IMP::loginTasks();

        if (Horde::getFormData('url')) {
            $url = Horde::getFormData('url');
            $url = IMP::addParameter($url, 'actionID=' . $actionID);
        } else {
            $url = _getInitialUrl($actionID);
        }
        header('Location: ' . $url);
        exit;
    } else {
        header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php', $reason), true));
        exit;
    }
}

/* No session, and no login attempt. Just go to the login page. */
require IMP_BASE . '/login.php';
