# Author:  Chao-Kuei Hung
# For more info, including license, please see doc/index.html

package RBTree;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
use Carp;
require Exporter;

use BST;

@ISA = qw(Exporter BST);
@EXPORT = qw();
@EXPORT_OK = qw();
%EXPORT_TAGS = (all => [@EXPORT_OK]);

sub new {
    my ($class, %opts) = @_;
    $class = ref($class) if ref($class);
    %opts = %{ ::merge_config_opts($class, \%opts) };
    my ($t) = delete $opts{-type};
    croak "'RBTree' code does not know how to process '$t' data\n"
	unless $t eq 'sortable';
    my ($self) = bless { }, $class;
    $self->SUPER::init(%opts);
    return $self;
}

sub insert {
    my ($self, $sk_cont, %opts) = @_;
    # $sk_cont is search key, should have the same structure as -content=>...
    my ($nn, $r, $focus, $grand, $parent, $uncle);
    $nn = $self->SUPER::insert($sk_cont, %opts);
    $nn->configure(-status=>"discard");
    $self->cget(-canvas)->set_mark(0);
    $focus = $nn;
    while (1) {
	$parent = $focus->parent();
	last if $parent->cget(-status) ne "discard";
	die if $parent->is_root(); # impossibe, because root is always black
	$grand = $parent->parent();
	$uncle = $grand->child(1 - $parent->rank());
	if (ref $uncle and $uncle->cget(-status) eq "discard") {
	    # then parent is not the root
	    $parent->configure(-status=>"done");
	    $uncle->configure(-status=>"done");
	    $grand->configure(-status=>"discard");
	    $self->cget(-canvas)->set_mark(0);
	    $focus = $grand;
	} else {
	    if ($focus->rank() != $parent->rank()) {
		if ($parent->rank() == 0) {
		    $parent->rotate_ccw();
		} else {
		    $parent->rotate_cw();
		}
		$self->cget(-canvas)->set_mark(0);
		($focus, $parent) = ($parent, $focus);
	    }
	    if ($parent->rank() == 0) {
		$grand->rotate_cw();
	    } else {
		$grand->rotate_ccw();
	    }
	    $parent->configure(-status=>"done");
	    $grand->configure(-status=>"discard");
	    $focus->configure(-status=>"discard");
	    $self->cget(-canvas)->set_mark(0);
	    last;
	}
    }
    # make sure root is always black
    $self->root()->configure(-status=>"done")
	unless $self->root()->cget(-status) eq "done";
    return $nn;
}

sub remove {
    my ($self, $node) = @_;
    print STDERR "remove() not implemented yet, ignored\n";
    return undef;
}

if ($0 =~ /RBTree.pm$/) {
# being tested as a stand-alone program, so run test code.

require "utilalgo";
my ($mw, $ctrl, $can);
$mw = MainWindow->new(-title=>"main_test");
$can->{main} = gen_can($mw, undef, -elevation=>1, -maxlevel=>2);
$ctrl = gen_ctrl($mw, $can);
my ($tr) = RBTree->new(-canvas=>$can->{main}, %{ do "data/countries.gr" });
$ctrl->configure(-recorder=>0);
Tk::MainLoop();

}

1;

