/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet;

import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.jet.JETReader;

public final class JETMark {
    protected int cursor;
    protected int line;
    protected int col;
    protected int fileid;
    protected String baseDir;
    protected char[] stream = null;
    protected Stack includeStack = null;
    protected String encoding = null;
    protected JETReader reader;

    JETMark(JETReader reader, char[] inStream, int fileid, String inBaseDir, String inEncoding) {
        this.reader = reader;
        this.stream = inStream;
        this.col = 0;
        this.line = 0;
        this.cursor = 0;
        this.fileid = fileid;
        this.baseDir = inBaseDir;
        this.encoding = inEncoding;
        this.includeStack = new Stack();
    }

    JETMark(JETMark other) {
        this.reader = other.reader;
        this.stream = other.stream;
        this.fileid = other.fileid;
        this.cursor = other.cursor;
        this.line = other.line;
        this.col = other.col;
        this.baseDir = other.baseDir;
        this.encoding = other.encoding;
        this.includeStack = new Stack();
        int i = 0;
        while (i < other.includeStack.size()) {
            this.includeStack.addElement(other.includeStack.elementAt(i));
            ++i;
        }
    }

    public void pushStream(char[] inStream, int inFileid, String inBaseDir, String inEncoding) {
        this.includeStack.push(new IncludeState(this.cursor, this.line, this.col, this.fileid, this.baseDir, this.encoding, this.stream));
        this.cursor = 0;
        this.line = 0;
        this.col = 0;
        this.fileid = inFileid;
        this.baseDir = inBaseDir;
        this.encoding = inEncoding;
        this.stream = inStream;
    }

    public boolean popStream() {
        if (this.includeStack.size() <= 0) {
            return false;
        }
        IncludeState state = (IncludeState)this.includeStack.pop();
        this.cursor = state.cursor;
        this.line = state.line;
        this.col = state.col;
        this.fileid = state.fileid;
        this.baseDir = state.baseDir;
        this.stream = state.stream;
        return true;
    }

    public String getFile() {
        return this.reader.getFile(this.fileid);
    }

    public String getLocalFile() {
        String file = this.reader.getFile(this.fileid);
        if (file.startsWith("file:/")) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile iFile = workspaceRoot.getFileForLocation((IPath)new Path(file.substring(6)));
            file = iFile.getFullPath().toString();
        }
        return file;
    }

    public int getFileId() {
        return this.fileid;
    }

    public int getCursor() {
        return this.cursor;
    }

    public String toShortString() {
        return "(" + this.line + "," + this.col + ")";
    }

    public String toString() {
        return String.valueOf(this.getLocalFile()) + "(" + this.line + "," + this.col + ")";
    }

    public String format(String key) {
        return CodeGenPlugin.getPlugin().getString(key, new Object[]{this.getLocalFile(), new Integer(this.line + 1), new Integer(this.col + 1), new Integer(this.cursor)});
    }

    public boolean equals(Object other) {
        if (other instanceof JETMark) {
            JETMark m = (JETMark)other;
            return this.reader == m.reader && this.fileid == m.fileid && this.cursor == m.cursor && this.line == m.line && this.col == m.col;
        }
        return false;
    }

    class IncludeState {
        int cursor;
        int line;
        int col;
        int fileid;
        String baseDir;
        String encoding;
        char[] stream = null;

        IncludeState(int inCursor, int inLine, int inCol, int inFileid, String inBaseDir, String inEncoding, char[] inStream) {
            this.cursor = inCursor;
            this.line = inLine;
            this.col = inCol;
            this.fileid = inFileid;
            this.baseDir = inBaseDir;
            this.encoding = inEncoding;
            this.stream = inStream;
        }
    }
}

