/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.change.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.change.ChangePackage;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.change.ResourceChange;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class ResourceChangeImpl
extends EObjectImpl
implements ResourceChange {
    protected static final String RESOURCE_URI_EDEFAULT = null;
    protected String resourceURI = RESOURCE_URI_EDEFAULT;
    protected static final Resource RESOURCE_EDEFAULT = null;
    protected Resource resource = RESOURCE_EDEFAULT;
    protected static final EList VALUE_EDEFAULT = null;
    protected EList listChanges = null;
    protected EList valueField = null;
    static /* synthetic */ Class class$0;

    protected ResourceChangeImpl() {
    }

    protected ResourceChangeImpl(Resource resource, EList value) {
        this();
        this.setResource(resource);
        this.setValue(value);
    }

    protected EClass eStaticClass() {
        return ChangePackage.eINSTANCE.getResourceChange();
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public void setResourceURI(String newResourceURI) {
        String oldResourceURI = this.resourceURI;
        this.resourceURI = newResourceURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldResourceURI, (Object)this.resourceURI));
        }
    }

    public Resource getResource() {
        ResourceSet resourceSet;
        Resource changeResource;
        if (this.resource == null && this.getResourceURI() != null && (changeResource = this.eResource()) != null && (resourceSet = changeResource.getResourceSet()) != null) {
            this.resource = resourceSet.getResource(URI.createURI((String)this.getResourceURI()), false);
        }
        return this.resource;
    }

    public void setResourceGen(Resource newResource) {
        Resource oldResource = this.resource;
        this.resource = newResource;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldResource, (Object)this.resource));
        }
    }

    public void setResource(Resource newResource) {
        this.setResourceGen(newResource);
        this.setResourceURI(newResource.getURI().toString());
    }

    public EList getValue() {
        if (this.valueField == null) {
            Resource resource = this.getResource();
            if (resource != null) {
                BasicEList changedList = new BasicEList((Collection)resource.getContents());
                this.apply((EList)changedList);
                this.valueField = changedList;
                return changedList;
            }
            return ECollections.EMPTY_ELIST;
        }
        return this.valueField;
    }

    protected void setValue(EList value) {
        this.valueField = value;
    }

    public EList getListChanges() {
        if (this.listChanges == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.change.ListChange");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.listChanges = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 3);
        }
        return this.listChanges;
    }

    public void apply() {
        Resource resource = this.getResource();
        if (resource != null && this.listChanges != null) {
            this.apply(resource.getContents());
        }
    }

    public void applyAndReverse() {
        Resource resource = this.getResource();
        if (resource != null && this.listChanges != null) {
            EList applyToList = resource.getContents();
            Iterator iter = this.getListChanges().iterator();
            while (iter.hasNext()) {
                ListChange listChange = (ListChange)iter.next();
                listChange.applyAndReverse(applyToList);
            }
            ECollections.reverse((EList)this.getListChanges());
            this.setValue(null);
        }
    }

    protected void apply(EList toList) {
        Iterator iter = this.getListChanges().iterator();
        while (iter.hasNext()) {
            ListChange listChange = (ListChange)iter.next();
            listChange.apply(toList);
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 3: {
                    return ((InternalEList)this.getListChanges()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getResourceURI();
            }
            case 1: {
                return this.getResource();
            }
            case 2: {
                return this.getValue();
            }
            case 3: {
                return this.getListChanges();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setResourceURI((String)newValue);
                return;
            }
            case 1: {
                this.setResource((Resource)newValue);
                return;
            }
            case 3: {
                this.getListChanges().clear();
                this.getListChanges().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setResourceURI(RESOURCE_URI_EDEFAULT);
                return;
            }
            case 1: {
                this.setResource(RESOURCE_EDEFAULT);
                return;
            }
            case 3: {
                this.getListChanges().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return RESOURCE_URI_EDEFAULT == null ? this.resourceURI != null : !RESOURCE_URI_EDEFAULT.equals(this.resourceURI);
            }
            case 1: {
                return RESOURCE_EDEFAULT == null ? this.resource != null : !RESOURCE_EDEFAULT.equals(this.resource);
            }
            case 2: {
                return VALUE_EDEFAULT == null ? this.getValue() != null : !VALUE_EDEFAULT.equals((Object)this.getValue());
            }
            case 3: {
                return this.listChanges != null && !this.listChanges.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (resourceURI: ");
        result.append(this.resourceURI);
        result.append(", resource: ");
        result.append(this.resource);
        result.append(')');
        return result.toString();
    }
}

