/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2001-2004 by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef PROJECTSETTINGS_H
#define PROJECTSETTINGS_H

#include <qstring.h>
#include <qstringlist.h>
#include <qfont.h>
#include <qcolor.h>
#include <kurl.h>

#include "catalogsettings.h"

namespace KBabel {

struct SpellcheckSettings
{
   bool valid;
   bool noRootAffix;
   bool runTogether;
   int spellEncoding;
   int spellClient;
   QString spellDict;

   bool rememberIgnored;
   QString ignoreURL;

   bool onFlySpellcheck;
   
   SpellcheckSettings() { valid=false; }
};

struct CatManSettings
{
   QString poBaseDir;
   QString potBaseDir;

   bool openWindow;

   QStringList dirCommands;
   QStringList dirCommandNames;
   QStringList fileCommands;
   QStringList fileCommandNames;

   QString ignoreURL;

   bool killCmdOnExit;
   bool indexWords;

   bool flagColumn;
   bool fuzzyColumn;
   bool untranslatedColumn;
   bool totalColumn;
   bool cvsColumn;
   bool revisionColumn;
   bool translatorColumn;

};

struct SourceContextSettings 
{
    /**
     * A path, which can be used as @CODEROOT@ variable in @ref sourcePaths .
     * Defaults to empty string.
     */
    QString codeRoot;

    /**
     * List of paths, where the source file should be lookup. Can use @CODEROOT@ (replaced by @ref codeRoot),
     * @PACKAGE@ (replaced by package name), @PACKAGEDIR@ (replaced by the
     * longest known path of the package) and @COMMENTPATH@ (path extracted from comment specs.
     */
    QStringList sourcePaths;
    
    void SourceContextSettins() { codeRoot = QString::null; sourcePaths.clear(); }
};

/**
* This namespace provides static methods and variables to get the default
* values of configuration values
*/
namespace Defaults
{
   class Spellcheck
   {
    public:
       static const bool rememberIgnored;
       static QString ignoreURL();
       static const bool onFlySpellcheck;
    private:
       static QString _ignoreURL;
   };

   class CatalogManager
   {
    public:
       static QString poBaseDir();
       static QString potBaseDir();
       static const bool openWindow;

       static QStringList dirCommands();
       static QStringList dirCommandNames();
       static QStringList fileCommands();
       static QStringList fileCommandNames();

       static QString ignoreURL();

       static const bool killCmdOnExit;
       static const bool indexWords;

       static const bool flagColumn;
       static const bool fuzzyColumn;
       static const bool untranslatedColumn;
       static const bool totalColumn;
       static const bool cvsColumn;
       static const bool revisionColumn;
       static const bool translatorColumn;

    private:
       static QString _poBaseDir;
       static QString _potBaseDir;
       static QString _ignoreURL;
   };

    class SourceContextSettings
    {
     public:
        static QString codeRoot();
	static QStringList sourcePaths();
    };

}

}

#endif // PROJECTSETTINGS_H
