#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12528);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : clamav < 0.65_7";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has an installed version of the clamav package which is older
than 0.65_7.

clamav is a command-line virus scanner. The remote version of this software
contains a bug which may allow an attacker to disable the 'clamd' daemon
by sending a malformed uuencoded message which will be scanned by clamd.

If clamd is used in-line with a mail server, forcing it to exit may result
in a loss of e-mail messages on the side of the mail server.

Solution : http://www.vuxml.org/freebsd/74a9541d-5d6c-11d8-80e3-0020ed76ef5a.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the clamav package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^clamav", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"clamav-0.65_7") < 0 ) 
	security_hole(0);
