#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(12559);
 script_version ("$Revision: 1.2 $");
 name["english"] = "FreeBSD Ports : leafnode <= 1.9.47";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of the leafnode package which is older 
than 1.9.47.

leafnode is an NNTP package for offline news caching and reading. There is
a bug in the remote version of this software which may let an attacker
to cause this program to hang by sending a malformed news message.

To exploit this flaw, an attacker would need to send a specially malformed
message to a newsgroup visited by a leafnode user.

Solution : http://www.vuxml.org/freebsd/a051a4ec-3aa1-4dd1-9bdc-a61eb5700153.html
Risk factor : Low";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the subversion package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^leafnode-", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"leafnode-1.9.47") < 0 ) 
        {
        security_warning(0);
        exit(0);
        }
