#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(13656);
 script_bugtraq_id(10780, 10781);
 script_version ("$Revision: 1.7 $");
 script_cve_id("CAN-2004-0600", "CAN-2004-0686");
 name["english"] = "FreeBSD Ports: Samba < 2.2.10 (or Samba3 < 3.0.4_4)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of Samba installed which is older than 2.2.10
or 3.0.4_4

Samba provides file and printer sharing services to SMB/CIFS clients. Samba
comes with a utility called 'SWAT' which is a web-based administration
tool for Samba installations.

There are various buffer overflows in SWAT which may allow an attacker
to execute arbitrary commands on the remote host. 

There are also flaws in the samba server if the option 'mangling method'
is set to 'hash' in smb.conf.

Solution : http://www.vuxml.org/freebsd/2de14f7a-dad9-11d8-b59a-00061bc2ad93.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the Samba packages";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");


pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^samba-2", string:pkgs);
if ( pkg_cmp(pkg:package, reference:"samba-2.2.10") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}

package = egrep(pattern:"^samba3-3", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"samba3-3.0.4_4") < 0 ) 
	{
	security_hole(0);
	exit(0);
	}
else if ( package && pkg_cmp(pkg:package, reference:"samba3-3.0.4_4") >= 0 )
{
 	set_kb_item(name:"CAN-2004-0686", value:TRUE);
}

