#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(15494);
 script_version ("$Revision: 1.1 $");
 name["english"] = "FreeBSD Ports : xv < 3.10a_4";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host has a version of the 'xv' package which is older than 
version 3.10a_4

'xv' is an image viewing program.

The remote version of this software contains several buffer and heap overflows
when displaying malformed images. An attacker may exploit this flaw to execute
arbitrary code on the remote host.

Solution : http://www.vuxml.org/freebsd/fffacc93-16cb-11d9-bc4a-000c41e2cdad.html
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of the xv package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004 Tenable Network Security");
 family["english"] = "FreeBSD Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/FreeBSD/pkg_info");
 exit(0);
}



include("freebsd_package.inc");

pkgs = get_kb_item("Host/FreeBSD/pkg_info");

package = egrep(pattern:"^xv-[0-3]", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"xv-3.10a_4") < 0 ) 
        {
        security_hole(0);
        exit(0);
        }
package = egrep(pattern:"^xv-m17n-[0-3]", string:pkgs);
if ( package && pkg_cmp(pkg:package, reference:"xv-m17n-3.10a_4") < 0 ) 
        {
        security_hole(0);
        exit(0);
        }
