#TRUSTED 68d997ce7fd8524871a87ba3aa27dcdb45bcf8ae9d8a3f8baba1f4aeee8b2c8e9d4455fdf295a6b1ae0b7d7694fff3db3bc4261c4f73c3a189cedb60648c614af654558ce118953e5c59bcd1db3faadd28e6c1dfcbf4b7a87e816b906055d142e2f18bcda45328905c2134a25272a1e3ae3354425c75fd3dbf9ea277fdef8ea69eeb2f0f8709ebe4324a5002c9c30747be57069d719ee331b2201ca50ac80e22aca0b5af91e95aea160aefce8cbf9641a6ca675b82e2ad326500ea1f0bc5db1536c775bb707e30bd0858e0dc5e5db1325981adea9c9e54dac0a89646a518000ab2ce3c2571c457884381aabf6ac2c587a1a9033107b0a4524f33cd736bc6ffd6c8c16c5030eb65059d651ad27821ee5f634e4ebe7daede17776bf30fa298e4e1bb82d1921c5e6d6a1b4ca9687d5c40707222e1ffed6840706b8dfc2d766a6389035593ecfc8a695acbcb16299128f9d2ce8a33b5cdd80707979dca585bec2fc22d9947eb51576d1eb42b640545c7ea3d17505936ccc249812bfc40e2f3d1c3c7b67589e1a0ab22f5c7aa49b36d8f9b709aa109d6df9fff2ce2da437088666d0266605b33665e6a954e6e282b98c0aa4f665384faaffa7eaae64d00004ab75b8b14a88b9d0acb5b814a609a546045d37ed4f484014448293e87f89d740f9248cacfd646e4f2c32c438147975af2646596854d5a365edf00d96048e9c4b82c0210
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if ( ! defined_func("pread") ) exit(0);
if ( ! find_in_path("snmpwalk") ) exit(0);


if(description)
{
 script_id(14274);
 script_version ("1.4");
 name["english"] = "snmpwalk 'scanner'";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs snmpwalk against the remote machine to find open ports.
See the section 'plugins options' to configure it

Risk factor : None";

 script_description(english:desc["english"]);
 
 summary["english"] = "Find open ports with snmpwalk";
 script_summary(english:summary["english"]);
 
 script_category(ACT_SCANNER);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 family["english"] = "Port scanners";
 family["francais"] = "Scanners de ports";
 script_family(english:family["english"], francais:family["francais"]);

 script_dependencies("ping_host.nasl");

if (NASL_LEVEL < 2181) exit(0);	# Cannot run

 script_add_preference(name: "Community name :", type: "entry", value: "public");
 script_add_preference(name: "SNMP protocol :", type: "radio", value: "1;2c");
 script_add_preference(name: "SNMP transport layer :", type: "radio", value: "udp;tcp");
 script_add_preference(name: "TCP/UDP port :", type: "entry", value: "");
 script_add_preference(name: "Number of retries :", type: "entry", value: "");
 script_add_preference(name: "Timeout between retries :", type: "entry", value: "");
 exit(0);
}

#

if (NASL_LEVEL < 2181) exit(0);	# Cannot run

global_var	snmp_layer, argv, snmp_port, snmp_comm;

function make_argv(obj)
{
 local_var	i, p;

 i = 0;
 argv = NULL;
 argv[i++] = "snmpwalk";

 p = script_get_preference("SNMP protocol :");
 if (! p) p = "2c";
 argv[i++] = "-v";
 argv[i++] = p;

 snmp_layer = "udp";

 if (! v506)
 {
  p = script_get_preference("SNMP transport layer :");
  if (p)
  {
   argv[i++] = "-T";
   argv[i++] = p;
   snmp_layer = p;
  }
 }

 p = script_get_preference("Number of retries :");
 if (p && p =~ '^[0-9]+$')
 {
  argv[i++] = "-r";
  argv[i++] = p;
 }

 p = script_get_preference("Timeout between retries :");
 if (p && p =~ '^[0-9]+$')
 {
  argv[i++] = "-t";
  argv[i++] = p;
 }

 p = script_get_preference("TCP/UDP port :");
 if (p && p =~ '^[0-9]+$')
 {
  argv[i++] = "-p";
  argv[i++] = p;
  snmp_port = p;
 }

 if (!v506) argv[i++] = ip;

 p = script_get_preference("Community name :");
 if (strlen(p) == 0) p = "public";
 if (v506) argv[i++] = "-c";
 argv[i++] = p;
 snmp_comm = p;

 # Version 5.0.6 orlater: put the hostname *after* the options
 if (v506) argv[i++] = ip;

 argv[i++] = obj;
}


ver = pread(cmd: "snmpwalk", argv: make_list("snmpwalk", "-V"));
if (ereg(string: ver, pattern: "NET-SNMP version: +([6-9]\.|5\.([1-9]|0\.[6-9]))", icase: 1, multiline: 1))
  v506 = 1;
else
  v506 = 0;

ip = get_host_ip();

i = 0;
scanned = 0; udp_scanned = 0;
foreach o (
  make_list("tcp.tcpConnTable.tcpConnEntry.tcpConnLocalPort.0.0.0.0",
            "tcp.tcpConnTable.tcpConnEntry.tcpConnLocalPort." + ip,
            "udp.udpTable.udpEntry.udpLocalPort.0.0.0.0", 
            "udp.udpTable.udpEntry.udpLocalPort." + ip))
{
 scanner_status(current: 0, total: i++);
 make_argv(obj: o);
 buf = pread(cmd: "snmpwalk", argv: argv);
 proto = substr(o, 0, 2);
 if (buf)
 {
  foreach line( split(buf))
  {
   v = eregmatch(pattern: '=[ \t]*([a-zA-Z0-9-]+:)?[ \t]*([0-9]+)[ \t\r\n]*$',
		string: line);
   if (! isnull(v))
   {
    scanner_add_port(proto: proto, port: v[2]);
    scanned ++;
    if (proto == "udp") udp_scanned ++;
   }
  }
 } 
}

if (scanned)
{
 set_kb_item(name: "Host/scanned", value: TRUE);
 security_note(port: snmp_port, proto: snmp_layer, 
data: strcat("snmpwalk could get the open port list with the community name ", snmp_comm));
}

if (udp_scanned) set_kb_item(name: "Host/udp_scanned", value: TRUE);

exit(0);

# make_argv(obj: "host.hrSWInstalled.hrSWInstalledTable.hrSWInstalledEntry.hrSWInstalledName");

