/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.SAXXMIHandler;
import org.eclipse.emf.ecore.xml.type.AnyType;

public class UML2Handler
extends SAXXMIHandler {
    protected final Map urisToProxies = new HashMap();

    public UML2Handler(XMLResource xmiResource, XMLHelper helper, Map options) {
        super(xmiResource, helper, options);
    }

    public void endDocument() {
        super.endDocument();
        if (this.extendedMetaData != null) {
            Iterator demandedPackages = this.extendedMetaData.demandedPackages().iterator();
            while (demandedPackages.hasNext()) {
                URI locationURI;
                EPackage ePackage = (EPackage)demandedPackages.next();
                String nsURI = ePackage.getNsURI();
                if (nsURI == null) continue;
                if (this.urisToLocations != null && (locationURI = (URI)this.urisToLocations.get(nsURI)) != null) {
                    ResourceImpl resource = new ResourceImpl();
                    resource.setURI(locationURI);
                    resource.getContents().add((Object)ePackage);
                }
                Iterator entries = this.helper.getPrefixToNamespaceMap().iterator();
                while (entries.hasNext()) {
                    Map.Entry entry = (Map.Entry)entries.next();
                    if (!nsURI.equals(entry.getValue())) continue;
                    ePackage.setNsPrefix((String)entry.getKey());
                }
            }
        }
    }

    protected EObject validateCreateObjectFromFactory(EFactory factory, String typeName, EObject newObject, EStructuralFeature feature) {
        if (!(this.objects.peek() instanceof AnyType) && newObject != null && newObject.eIsProxy() && !this.sameDocumentProxies.contains(newObject)) {
            EObject proxy;
            URI proxyURI = ((InternalEObject)newObject).eProxyURI();
            HashMap<String, EObject> typeNamesToProxies = (HashMap<String, EObject>)this.urisToProxies.get(proxyURI);
            if (typeNamesToProxies == null) {
                typeNamesToProxies = new HashMap<String, EObject>();
                this.urisToProxies.put(proxyURI, typeNamesToProxies);
            }
            if ((proxy = (EObject)typeNamesToProxies.get(typeName)) == null) {
                proxy = newObject;
                typeNamesToProxies.put(typeName, proxy);
            }
            newObject = proxy;
        }
        return super.validateCreateObjectFromFactory(factory, typeName, newObject, feature);
    }
}

