/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.test;

import java.io.File;
import java.io.OutputStream;
import java.util.Iterator;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDPlugin;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.util.XSDPrototypicalSchema;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XSDMainTest {
    public static void main(String[] args) {
        System.exit((Integer)new XSDMainTest().run(args));
    }

    public XSDMainTest() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
    }

    public Object run(Object object) {
        try {
            String[] arguments = (String[])object;
            if (arguments.length == 0) {
                System.out.println("<!-- ** PurchaseOrderSchema ** -->");
                XSDSchema xsdPurchaseOrderSchema = XSDPrototypicalSchema.getPurchaseOrderSchema();
                if (xsdPurchaseOrderSchema.getElement() == null) {
                    xsdPurchaseOrderSchema.updateElement();
                }
                XSDResourceImpl.serialize((OutputStream)System.out, (Element)xsdPurchaseOrderSchema.getElement());
                System.out.println("<!-- ** PrototypicalSchema ** -->");
                XSDSchema xsdSchema = XSDPrototypicalSchema.getPrototypicalSchema();
                if (xsdSchema.getElement() == null) {
                    xsdSchema.updateElement();
                }
                XSDResourceImpl.serialize((OutputStream)System.out, (Element)xsdSchema.getElement());
                System.out.println("===== clone =====");
                XSDSchema clonedSchema = (XSDSchema)xsdSchema.cloneConcreteComponent(true, true);
                clonedSchema.setElement(null);
                clonedSchema.updateElement();
                XSDResourceImpl.serialize((OutputStream)System.out, (Element)clonedSchema.getElement());
                System.out.println("===== clone schema for schema =====");
                XSDSchema clonedSchemaForSchema = (XSDSchema)clonedSchema.getSchemaForSchema().cloneConcreteComponent(true, true);
                clonedSchemaForSchema.setElement(null);
                clonedSchemaForSchema.updateElement();
                XSDResourceImpl.serialize((OutputStream)System.out, (Element)clonedSchemaForSchema.getElement());
            } else if (arguments[0].equals("-printTest")) {
                XSDPrototypicalSchema xsdPrototypicalSchema = XSDPrototypicalSchema.getInstance();
                int i = 1;
                while (i < arguments.length) {
                    xsdPrototypicalSchema.printSchema(arguments[i]);
                    ++i;
                }
            } else if (arguments[0].equals("-createTest")) {
                Document document = (Document)XSDPrototypicalSchema.getPurchaseOrderSchema().getDocument().cloneNode(true);
                XSDSchema xsdSchema = XSDPrototypicalSchema.getInstance().createSchema(document.getDocumentElement());
                if (xsdSchema != null) {
                    if (xsdSchema.getElement() == null) {
                        xsdSchema.updateElement();
                    }
                    XSDResourceImpl.serialize((OutputStream)System.out, (Element)xsdSchema.getElement());
                }
            } else if (arguments[0].equals("-saveTest")) {
                XSDPrototypicalSchema.getInstance().savePurchaseOrderSchema(arguments[1]);
            } else if (arguments[0].equals("-traceLoad")) {
                int i = 1;
                while (i < arguments.length) {
                    XSDPrototypicalSchema.getInstance().traceLoading(arguments[i]);
                    ++i;
                }
            } else if (arguments[0].equals("-clone")) {
                XSDPrototypicalSchema.getInstance().printComponent((OutputStream)System.out, XSDPrototypicalSchema.getInstance().cloneComponent((XSDConcreteComponent)XSDPrototypicalSchema.getPurchaseOrderSchema(), false));
                XSDPrototypicalSchema.getInstance().printComponent((OutputStream)System.out, XSDPrototypicalSchema.getInstance().cloneComponent((XSDConcreteComponent)XSDPrototypicalSchema.getPurchaseOrderSchema(), true));
            } else if (arguments[0].equals("-crossReferenceTest")) {
                XSDPrototypicalSchema.getInstance().crossReferenceTest(System.out);
            } else if (arguments[0].equals("-validate")) {
                int i = 1;
                while (i < arguments.length) {
                    this.validate(arguments[i]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < arguments.length) {
                    System.out.println("<!-- << " + arguments[i] + " >> -->");
                    this.loadAndPrint(arguments[i]);
                    ++i;
                }
            }
            return new Integer(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Integer(1);
        }
    }

    protected void printSchemaStart(XSDSchema xsdSchema) {
        System.out.print("<schema targetNamespace=\"");
        if (xsdSchema.getTargetNamespace() != null) {
            System.out.print(xsdSchema.getTargetNamespace());
        }
        System.out.print("\" schemaLocation=\"");
        if (xsdSchema.getSchemaLocation() != null) {
            System.out.print(xsdSchema.getSchemaLocation());
        }
        System.out.print("\">");
    }

    protected void printDirectives(String indent, XSDSchema xsdSchema) {
        System.out.print(indent);
        this.printSchemaStart(xsdSchema);
        System.out.println();
        if (!xsdSchema.getReferencingDirectives().isEmpty()) {
            System.out.println(String.valueOf(indent) + "  <referencingDirectives>");
            Iterator referencingDirectives = xsdSchema.getReferencingDirectives().iterator();
            while (referencingDirectives.hasNext()) {
                XSDSchemaDirective xsdSchemaDirective = (XSDSchemaDirective)referencingDirectives.next();
                XSDSchema referencingSchema = xsdSchemaDirective.getSchema();
                System.out.print(String.valueOf(indent) + "    ");
                this.printSchemaStart(referencingSchema);
                System.out.println();
                System.out.print(String.valueOf(indent) + "      ");
                if (xsdSchemaDirective instanceof XSDImport) {
                    XSDImport xsdImport = (XSDImport)xsdSchemaDirective;
                    System.out.print("<import namespace=\"");
                    if (xsdImport.getNamespace() != null) {
                        System.out.print(xsdImport.getNamespace());
                    }
                    System.out.print("\" schemaLocation=\"");
                } else if (xsdSchemaDirective instanceof XSDRedefine) {
                    System.out.print("<redefine schemaLocation=\"");
                } else if (xsdSchemaDirective instanceof XSDInclude) {
                    System.out.print("<include schemaLocation=\"");
                }
                if (xsdSchemaDirective.getSchemaLocation() != null) {
                    System.out.print(xsdSchemaDirective.getSchemaLocation());
                }
                System.out.println("\"/>");
                System.out.println(String.valueOf(indent) + "    </schema>");
            }
            System.out.println(String.valueOf(indent) + "  </referencingDirectives>");
        }
        if (!xsdSchema.getIncorporatedVersions().isEmpty()) {
            System.out.println(String.valueOf(indent) + "  <incorporatedVersions>");
            Iterator incorporatedVersions = xsdSchema.getIncorporatedVersions().iterator();
            while (incorporatedVersions.hasNext()) {
                XSDSchema incorporatedVersion = (XSDSchema)incorporatedVersions.next();
                this.printDirectives(String.valueOf(indent) + "    ", incorporatedVersion);
            }
            System.out.println(String.valueOf(indent) + "  </incorporatedVersions>");
        }
        System.out.println(String.valueOf(indent) + "</schema>");
    }

    public void loadAndPrint(String xsdFile) throws Exception {
        File file = new File(xsdFile);
        URI uri = file.isFile() ? URI.createFileURI((String)file.getCanonicalFile().toString()) : URI.createURI((String)xsdFile);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        XSDResourceImpl xsdMainResource = (XSDResourceImpl)resourceSet.createResource(URI.createURI((String)"*.xsd"));
        xsdMainResource.setURI(uri);
        xsdMainResource.load(resourceSet.getLoadOptions());
        Iterator resources = resourceSet.getResources().iterator();
        while (resources.hasNext()) {
            Object resource = resources.next();
            if (!(resource instanceof XSDResourceImpl)) continue;
            XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
            XSDSchema xsdSchema = xsdResource.getSchema();
            System.out.println("<!-- ===== Schema Composition =====");
            this.printDirectives("  ", xsdSchema);
            System.out.println("-->");
            Element element = xsdSchema.getElement();
            if (element == null) continue;
            XSDResourceImpl.serialize((OutputStream)System.out, (Element)element);
        }
        XSDSchema xsdMainSchema = xsdMainResource.getSchema();
        xsdMainSchema.setDocument(null);
        xsdMainSchema.setElement(null);
        xsdMainSchema.updateElement();
        System.out.println("<!-- [ " + xsdMainSchema.getSchemaLocation() + " ] -->");
        XSDResourceImpl.serialize((OutputStream)System.out, (Element)xsdMainSchema.getElement());
    }

    public void validate(String xsdFile) throws Exception {
        File file = new File(xsdFile);
        URI uri = file.isFile() ? URI.createFileURI((String)file.getCanonicalFile().toString()) : URI.createURI((String)xsdFile);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getLoadOptions().put(XSDResourceImpl.XSD_TRACK_LOCATION, Boolean.TRUE);
        XSDResourceImpl xsdMainResource = (XSDResourceImpl)resourceSet.createResource(URI.createURI((String)"*.xsd"));
        xsdMainResource.setURI(uri);
        xsdMainResource.load(resourceSet.getLoadOptions());
        Iterator resources = resourceSet.getResources().iterator();
        while (resources.hasNext()) {
            Object resource = resources.next();
            if (!(resource instanceof XSDResourceImpl)) continue;
            XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
            System.err.println("--> " + xsdResource.getURI());
            XSDSchema xsdSchema = xsdResource.getSchema();
            xsdSchema.validate();
            if (xsdSchema.getAllDiagnostics().isEmpty()) continue;
            Iterator i = xsdSchema.getAllDiagnostics().iterator();
            while (i.hasNext()) {
                XSDDiagnostic xsdDiagnostic = (XSDDiagnostic)i.next();
                String localizedSeverity = XSDPlugin.INSTANCE.getString("_UI_XSDDiagnosticSeverity_" + xsdDiagnostic.getSeverity());
                System.err.println(XSDPlugin.INSTANCE.getString("_UI_DiagnosticFileLineColumn_message", new Object[]{localizedSeverity, xsdDiagnostic.getLocationURI(), new Integer(xsdDiagnostic.getLine()), new Integer(xsdDiagnostic.getColumn())}));
                System.err.println(xsdDiagnostic.getMessage());
            }
        }
    }

    public static class Runnable
    extends XSDMainTest
    implements IPlatformRunnable {
    }
}

