/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.rose2ecore.parser;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.List;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.RoseComponent;
import org.eclipse.emf.codegen.ecore.rose2ecore.parser.RoseNode;

public class RoseWriter
extends RoseComponent {
    public static final String PROGRESS = "ROSE_WRITE_PROGRESS";
    protected BufferedWriter buffWriter;
    protected RoseNode versionTree;
    protected RoseNode modelTree;
    protected int justIndex;
    protected int lower = 0;
    protected int upper = 100;
    protected int oldValue;
    protected int progressIncrement = 10;

    public RoseWriter(String fileName, RoseNode versionTree, RoseNode modelTree) throws Exception {
        this.buffWriter = new BufferedWriter(new FileWriter(fileName));
        this.versionTree = versionTree;
        this.modelTree = modelTree;
    }

    public void setProgressIncrement(int progressIncrement) {
        this.progressIncrement = progressIncrement;
    }

    public void setLower(int lower) {
        this.lower = lower;
        this.oldValue = lower;
    }

    public int getLower() {
        return this.lower;
    }

    public void setUpper(int upper) {
        this.upper = upper;
    }

    public int getUpper() {
        return this.upper;
    }

    public void write() throws Exception {
        if (this.buffWriter == null) {
            return;
        }
        this.oldValue = this.lower;
        this.justIndex = 0;
        this.buffWriter.newLine();
        this.writeObject(this.versionTree);
        this.buffWriter.newLine();
        this.buffWriter.newLine();
        if (this.modelTree.getRoseNodeType() == 2) {
            this.writeObject(this.modelTree);
        } else {
            this.writeList(this.modelTree);
        }
        this.buffWriter.newLine();
        this.buffWriter.close();
    }

    private void writeExpr(RoseNode tree) throws Exception {
        if (tree.getRoseNodeType() == 0) {
            this.buffWriter.write(9);
            this.buffWriter.write(tree.getValue());
        } else if (tree.getRoseNodeType() == 1) {
            List nodes = tree.getNodes();
            int i = 0;
            while (i < nodes.size()) {
                RoseNode node = (RoseNode)nodes.get(i);
                this.buffWriter.newLine();
                this.buffWriter.write(124);
                this.buffWriter.write(node.getValue());
                ++i;
            }
            this.buffWriter.newLine();
        } else if (tree.getRoseNodeType() == 3) {
            this.buffWriter.write(32);
            this.writeList(tree);
        } else if (tree.getRoseNodeType() == 2) {
            this.buffWriter.write(32);
            this.writeObject(tree);
        } else if (tree.getRoseNodeType() == 4) {
            this.buffWriter.write(9);
            this.writeValue(tree);
        }
    }

    private void writeList(RoseNode tree) throws Exception {
        String key = tree.getKey();
        if (!key.equals("collection")) {
            ++this.justIndex;
            this.buffWriter.write("(list ");
            this.buffWriter.write(tree.getValue());
        }
        List nodes = tree.getNodes();
        int j = 0;
        while (j < nodes.size()) {
            RoseNode node = (RoseNode)nodes.get(j);
            this.buffWriter.newLine();
            int i = 0;
            while (i < this.justIndex) {
                this.buffWriter.write(9);
                ++i;
            }
            if (node.getRoseNodeType() == 2) {
                this.writeObject(node);
            } else if (node.getRoseNodeType() == 0) {
                this.buffWriter.write(node.getValue());
            } else {
                System.out.println("!!!!! error in writeLists !!!!! " + node.getRoseNodeType());
                System.exit(0);
            }
            ++j;
        }
        if (!key.equals("collection")) {
            this.buffWriter.write(41);
            --this.justIndex;
        }
    }

    public void writeObject(RoseNode tree) throws Exception {
        ++this.justIndex;
        this.buffWriter.write("(object ");
        this.buffWriter.write(tree.getValue());
        List nodes = tree.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            RoseNode node = (RoseNode)nodes.get(i);
            this.writePair(node);
            ++i;
        }
        this.buffWriter.write(41);
        --this.justIndex;
    }

    public void writeValue(RoseNode tree) throws Exception {
        ++this.justIndex;
        this.buffWriter.write("(value ");
        this.buffWriter.write(tree.getValue());
        List nodes = tree.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            RoseNode node = (RoseNode)nodes.get(i);
            this.writeExpr(node);
            ++i;
        }
        this.buffWriter.write(41);
        --this.justIndex;
    }

    public void writePair(RoseNode node) throws Exception {
        this.buffWriter.newLine();
        int i = 0;
        while (i < this.justIndex) {
            this.buffWriter.write(9);
            ++i;
        }
        this.buffWriter.write(node.getKey());
        this.writeExpr(node);
    }
}

