# -*- encoding: binary -*-
require 'rainbows/fiber/rev'

# A combination of the Rev and FiberSpawn models.  This allows Ruby
# 1.9 Fiber-based concurrency for application processing while
# exposing a synchronous execution model and using scalable network
# concurrency provided by Rev.  A "rack.input" is exposed as well
# being Sunshowers-compatible.  Applications are strongly advised to
# wrap all slow IO objects (sockets, pipes) using the
# Rainbows::Fiber::IO or a Rev-compatible class whenever possible.
module Rainbows::RevFiberSpawn

  include Rainbows::Base
  include Rainbows::Fiber::Rev

  def worker_loop(worker) # :nodoc:
    Rainbows::Response.setup(Server)
    init_worker_process(worker)
    Server.const_set(:MAX, @worker_connections)
    Rainbows::Fiber::Base.setup(Server, nil)
    Server.const_set(:APP, G.server.app)
    Heartbeat.new(1, true).attach(Rev::Loop.default)
    kato = Kato.new.attach(Rev::Loop.default)
    Rainbows::Fiber::Rev::Methods.const_set(:KATO, kato)
    LISTENERS.map! { |s| Server.new(s).attach(Rev::Loop.default) }
    Rev::Loop.default.run
  end
end
