/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader;

import java.io.Serializable;
import java.util.HashMap;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class DependencyCollector
implements Serializable,
Cloneable {
    private HashMap dependencies;
    private static final long serialVersionUID = -3568774359923270189L;

    public DependencyCollector(ResourceKey resourceKey, long l) {
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        this.dependencies = new HashMap();
        this.dependencies.put(resourceKey, new Long(l));
    }

    public ResourceKey[] getDependencies() {
        return this.dependencies.keySet().toArray(new ResourceKey[this.dependencies.size()]);
    }

    public void add(Resource resource) {
        if (resource == null) {
            throw new NullPointerException();
        }
        ResourceKey[] resourceKeyArray = resource.getDependencies();
        for (int i = 0; i < resourceKeyArray.length; ++i) {
            ResourceKey resourceKey = resourceKeyArray[i];
            long l = resource.getVersion(resourceKey);
            this.add(resourceKey, l);
        }
    }

    public void add(ResourceKey resourceKey, long l) {
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        this.dependencies.put(resourceKey, new Long(l));
    }

    public long getVersion(ResourceKey resourceKey) {
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        Long l = (Long)this.dependencies.get(resourceKey);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public Object clone() throws CloneNotSupportedException {
        DependencyCollector dependencyCollector = (DependencyCollector)super.clone();
        dependencyCollector.dependencies = (HashMap)this.dependencies.clone();
        return dependencyCollector;
    }
}

