/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.cache;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class CachingResourceData
implements ResourceData,
Serializable {
    private static final int CACHE_THRESHOLD = 524288;
    private ResourceData data;
    private HashMap attributes;
    private transient byte[] rawData;
    private static final long serialVersionUID = -1749415356208356705L;

    public CachingResourceData(ResourceData resourceData) {
        if (resourceData == null) {
            throw new NullPointerException();
        }
        this.data = resourceData;
    }

    public InputStream getResourceAsStream(ResourceManager resourceManager) throws ResourceLoadingException {
        byte[] byArray = this.getResource(resourceManager);
        return new ByteArrayInputStream(byArray);
    }

    public long getLength() {
        if (this.rawData != null) {
            return this.rawData.length;
        }
        return this.data.getLength();
    }

    public synchronized byte[] getResource(ResourceManager resourceManager) throws ResourceLoadingException {
        if (this.rawData == null) {
            this.rawData = this.data.getResource(resourceManager);
        }
        return (byte[])this.rawData.clone();
    }

    public synchronized int getResource(ResourceManager resourceManager, byte[] byArray, long l, int n) throws ResourceLoadingException {
        int n2;
        int n3;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if ((long)byArray.length < l + (long)n) {
            throw new IndexOutOfBoundsException();
        }
        if (this.rawData == null) {
            this.rawData = this.data.getResource(resourceManager);
        }
        if ((n3 = Math.min(this.rawData.length - (n2 = (int)(Integer.MAX_VALUE & l)), n)) <= 0) {
            return -1;
        }
        System.arraycopy(this.rawData, n2, byArray, 0, n3);
        return n3;
    }

    public synchronized Object getAttribute(String string) {
        Object object;
        if (this.attributes == null) {
            this.attributes = new HashMap();
        } else {
            object = this.attributes.get(string);
            if (object != null) {
                return object;
            }
        }
        object = this.data.getAttribute(string);
        if (object != null) {
            this.attributes.put(string, object);
        }
        return object;
    }

    public ResourceKey getKey() {
        return this.data.getKey();
    }

    public long getVersion(ResourceManager resourceManager) throws ResourceLoadingException {
        return this.data.getVersion(resourceManager);
    }

    public static ResourceData createCached(ResourceData resourceData) {
        Number number;
        Object object = resourceData.getAttribute("content-length");
        if (object instanceof Number && (number = (Number)object).intValue() < 524288) {
            return new CachingResourceData(resourceData);
        }
        return resourceData;
    }
}

