/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.factory;

import java.io.IOException;
import java.io.InputStream;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.FactoryModule;

public abstract class AbstractFactoryModule
implements FactoryModule {
    protected AbstractFactoryModule() {
    }

    protected abstract int[] getFingerPrint();

    protected abstract String[] getMimeTypes();

    protected abstract String[] getFileExtensions();

    public int getHeaderFingerprintSize() {
        int[] nArray = this.getFingerPrint();
        if (nArray == null) {
            return 0;
        }
        return nArray.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int canHandleResource(ResourceManager resourceManager, ResourceData resourceData) throws ResourceCreationException, ResourceLoadingException {
        try {
            InputStream inputStream = resourceData.getResourceAsStream(resourceManager);
            try {
                if (this.canHandleResourceByContent(inputStream)) {
                    int n = 4000;
                    return n;
                }
                String string = (String)resourceData.getAttribute("content-type");
                if (string != null && this.canHandleResourceByMimeType(string)) {
                    int n = 2000;
                    return n;
                }
                String string2 = (String)resourceData.getAttribute("filename");
                if (string2 != null && this.canHandleResourceByName(string2)) {
                    int n = 2000;
                    return n;
                }
                int n = -1;
                return n;
            }
            finally {
                inputStream.close();
            }
        }
        catch (ResourceLoadingException resourceLoadingException) {
            throw resourceLoadingException;
        }
        catch (Exception exception) {
            throw new ResourceCreationException("Failed to load or check content", exception);
        }
    }

    protected boolean canHandleResourceByContent(InputStream inputStream) throws IOException {
        int[] nArray = this.getFingerPrint();
        if (nArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == inputStream.read()) continue;
            return false;
        }
        return true;
    }

    protected boolean canHandleResourceByMimeType(String string) {
        String[] stringArray = this.getMimeTypes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean canHandleResourceByName(String string) {
        String[] stringArray = this.getFileExtensions();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }
}

