/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.loader.URLResourceData;

public class URLResourceLoader
implements ResourceLoader {
    public boolean isSupportedKey(ResourceKey resourceKey) {
        return URLResourceLoader.class.getName().equals(resourceKey.getSchema());
    }

    public ResourceKey createKey(Object object, Map map) throws ResourceKeyCreationException {
        String string;
        if (object instanceof URL) {
            return new ResourceKey(URLResourceLoader.class.getName(), object, map);
        }
        if (object instanceof String && ((string = (String)object).indexOf("://") >= 0 || string.startsWith("file:/"))) {
            try {
                return new ResourceKey(URLResourceLoader.class.getName(), new URL(string), map);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ResourceKeyCreationException("Malformed value: " + object);
            }
        }
        return null;
    }

    public ResourceKey deriveKey(ResourceKey resourceKey, String string, Map map) throws ResourceKeyCreationException {
        if (!this.isSupportedKey(resourceKey)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        try {
            HashMap hashMap;
            URL uRL = string != null ? new URL((URL)resourceKey.getIdentifier(), string) : (URL)resourceKey.getIdentifier();
            if (map != null) {
                hashMap = new HashMap();
                hashMap.putAll(resourceKey.getFactoryParameters());
                hashMap.putAll(map);
            } else {
                hashMap = resourceKey.getFactoryParameters();
            }
            return new ResourceKey(resourceKey.getSchema(), uRL, hashMap);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ResourceKeyCreationException("Malformed value: " + string);
        }
    }

    public URL toURL(ResourceKey resourceKey) {
        return (URL)resourceKey.getIdentifier();
    }

    public ResourceData load(ResourceKey resourceKey) throws ResourceLoadingException {
        if (!this.isSupportedKey(resourceKey)) {
            throw new ResourceLoadingException("Key format is not recognized.");
        }
        return new URLResourceData(resourceKey);
    }
}

