/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.resource;

import java.io.InputStream;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;

public class ClassloaderResourceData
extends AbstractResourceData {
    private ResourceKey key;
    private String resourcePath;
    private static final long serialVersionUID = 980009972320937886L;

    public ClassloaderResourceData(ResourceKey resourceKey) {
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        this.key = resourceKey;
        String string = (String)resourceKey.getIdentifier();
        this.resourcePath = string.substring(6);
    }

    public InputStream getResourceAsStream(ResourceManager resourceManager) throws ResourceLoadingException {
        InputStream inputStream = ObjectUtilities.getResourceAsStream((String)this.resourcePath, ClassloaderResourceData.class);
        if (inputStream == null) {
            throw new ResourceLoadingException("Resource is not available: " + this.resourcePath);
        }
        return inputStream;
    }

    public Object getAttribute(String string) {
        if (string.equals("filename")) {
            return LoaderUtils.getFileName(this.resourcePath);
        }
        return null;
    }

    public long getVersion(ResourceManager resourceManager) throws ResourceLoadingException {
        return 0L;
    }

    public ResourceKey getKey() {
        return this.key;
    }
}

