/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.helper;

import com.sun.star.comp.helper.ComponentContextEntry;
import com.sun.star.comp.helper.Disposer;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ComponentContext
implements XComponentContext,
XComponent {
    private static final boolean DEBUG = false;
    private static final String SMGR_NAME = "/singletons/com.sun.star.lang.theServiceManager";
    private static final String TDMGR_NAME = "/singletons/com.sun.star.reflection.theTypeDescriptionManager";
    private Hashtable m_table;
    private XComponentContext m_xDelegate;
    private XMultiComponentFactory m_xSMgr;
    private boolean m_bDisposeSMgr;
    private Vector m_eventListener = new Vector();

    public ComponentContext(Hashtable hashtable, XComponentContext xComponentContext) {
        this.m_table = hashtable;
        this.m_xDelegate = xComponentContext;
        this.m_xSMgr = null;
        this.m_bDisposeSMgr = false;
        Object object = hashtable.get(SMGR_NAME);
        if (object != null) {
            if (object instanceof ComponentContextEntry) {
                object = ((ComponentContextEntry)object).m_value;
            }
            this.m_xSMgr = UnoRuntime.queryInterface(XMultiComponentFactory.class, object);
        }
        if (this.m_xSMgr != null) {
            this.m_bDisposeSMgr = true;
        } else if (this.m_xDelegate != null) {
            this.m_xSMgr = this.m_xDelegate.getServiceManager();
        }
        XComponent xComponent = UnoRuntime.queryInterface(XComponent.class, (Object)this.m_xDelegate);
        if (xComponent != null) {
            xComponent.addEventListener(new Disposer(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueByName(String string) {
        Object v = this.m_table.get(string);
        if (v != null) {
            if (v instanceof ComponentContextEntry) {
                ComponentContextEntry componentContextEntry = (ComponentContextEntry)v;
                if (componentContextEntry.m_lateInit != null) {
                    XInterface xInterface;
                    Object object;
                    Object object2 = null;
                    try {
                        object = (String)componentContextEntry.m_lateInit;
                        if (object != null) {
                            if (this.m_xSMgr != null) {
                                object2 = this.m_xSMgr.createInstanceWithContext((String)object, this);
                            }
                        } else {
                            xInterface = UnoRuntime.queryInterface(XSingleComponentFactory.class, componentContextEntry.m_lateInit);
                            if (xInterface != null) {
                                object2 = xInterface.createInstanceWithContext(this);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (object2 != null) {
                        object = componentContextEntry;
                        synchronized (object) {
                            if (componentContextEntry.m_lateInit != null) {
                                componentContextEntry.m_value = object2;
                                componentContextEntry.m_lateInit = null;
                            } else {
                                xInterface = UnoRuntime.queryInterface(XComponent.class, object2);
                                if (xInterface != null) {
                                    xInterface.dispose();
                                }
                            }
                        }
                    }
                }
                return componentContextEntry.m_value;
            }
            return v;
        }
        if (this.m_xDelegate != null) {
            return this.m_xDelegate.getValueByName(string);
        }
        return Any.VOID;
    }

    public XMultiComponentFactory getServiceManager() {
        return this.m_xSMgr;
    }

    public void dispose() {
        Object object;
        XInterface xInterface;
        EventObject eventObject = new EventObject(this);
        Enumeration enumeration = this.m_eventListener.elements();
        while (enumeration.hasMoreElements()) {
            xInterface = (XEventListener)enumeration.nextElement();
            xInterface.disposing(eventObject);
        }
        this.m_eventListener.removeAllElements();
        xInterface = null;
        Enumeration enumeration2 = this.m_table.keys();
        while (enumeration2.hasMoreElements()) {
            XComponent xComponent;
            object = (String)enumeration2.nextElement();
            if (((String)object).equals(SMGR_NAME)) continue;
            Object object2 = this.m_table.get(object);
            if (object2 instanceof ComponentContextEntry) {
                object2 = ((ComponentContextEntry)object2).m_value;
            }
            if ((xComponent = UnoRuntime.queryInterface(XComponent.class, object2)) == null) continue;
            if (((String)object).equals(TDMGR_NAME)) {
                xInterface = xComponent;
                continue;
            }
            xComponent.dispose();
        }
        this.m_table.clear();
        if (this.m_bDisposeSMgr && (object = UnoRuntime.queryInterface(XComponent.class, (Object)this.m_xSMgr)) != null) {
            object.dispose();
        }
        this.m_xSMgr = null;
        if (xInterface != null) {
            xInterface.dispose();
        }
    }

    public void addEventListener(XEventListener xEventListener) {
        if (xEventListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (this.m_eventListener.contains(xEventListener)) {
            throw new RuntimeException("Listener already registred.");
        }
        this.m_eventListener.addElement(xEventListener);
    }

    public void removeEventListener(XEventListener xEventListener) {
        if (xEventListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (!this.m_eventListener.contains(xEventListener)) {
            throw new RuntimeException("Listener is not registered.");
        }
        this.m_eventListener.removeElement(xEventListener);
    }
}

