/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.stream.WrappedInputStream;
import org.pentaho.reporting.libraries.repository.stream.WrappedOutputStream;

public class StreamContentItem
implements ContentItem {
    private WrappedInputStream inputStream;
    private WrappedOutputStream outputStream;
    private ContentLocation parent;
    private String name;

    public StreamContentItem(String string, ContentLocation contentLocation, WrappedInputStream wrappedInputStream, WrappedOutputStream wrappedOutputStream) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (contentLocation == null) {
            throw new NullPointerException();
        }
        this.name = string;
        this.parent = contentLocation;
        this.inputStream = wrappedInputStream;
        this.outputStream = wrappedOutputStream;
    }

    public boolean isReadable() {
        if (this.inputStream == null) {
            return false;
        }
        return !this.inputStream.isClosed();
    }

    public boolean isWriteable() {
        if (this.outputStream == null) {
            return false;
        }
        return !this.outputStream.isClosed();
    }

    public String getMimeType() throws ContentIOException {
        return this.getRepository().getMimeRegistry().getMimeType(this);
    }

    public OutputStream getOutputStream() throws ContentIOException, IOException {
        return this.outputStream;
    }

    public InputStream getInputStream() throws ContentIOException, IOException {
        return this.inputStream;
    }

    public String getName() {
        return this.name;
    }

    public Object getContentId() {
        return this.parent.getName() + '/' + this.name;
    }

    public Object getAttribute(String string, String string2) {
        return null;
    }

    public boolean setAttribute(String string, String string2, Object object) {
        return false;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public Repository getRepository() {
        return this.parent.getRepository();
    }

    public boolean delete() {
        return false;
    }
}

