/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.zipreader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultMimeRegistry;
import org.pentaho.reporting.libraries.repository.MimeRegistry;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.zipreader.ZipReadContentLocation;

public class ZipReadRepository
implements Repository {
    private ZipReadContentLocation root;
    private MimeRegistry mimeRegistry;

    public ZipReadRepository(InputStream inputStream) throws IOException {
        this(inputStream, new DefaultMimeRegistry());
    }

    public ZipReadRepository(InputStream inputStream, MimeRegistry mimeRegistry) throws IOException {
        this.mimeRegistry = mimeRegistry;
        this.root = new ZipReadContentLocation(this, null, "");
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        if (zipEntry == null) {
            throw new IOException("This repository is empty or does not point to a ZIP file");
        }
        while (zipEntry != null) {
            String[] stringArray = RepositoryUtilities.splitPath(zipEntry.getName(), "/");
            if (zipEntry.isDirectory()) {
                this.root.updateDirectoryEntry(stringArray, 0, zipEntry);
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(zipEntry.getMethod()));
                IOUtils.getInstance().copyStreams((InputStream)zipInputStream, (OutputStream)deflaterOutputStream);
                deflaterOutputStream.flush();
                deflaterOutputStream.close();
                this.root.updateEntry(stringArray, 0, zipEntry, byteArrayOutputStream.toByteArray());
            }
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
    }

    public ContentLocation getRoot() throws ContentIOException {
        return this.root;
    }

    public MimeRegistry getMimeRegistry() {
        return this.mimeRegistry;
    }
}

