/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.XCallback;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XMessageBox;
import com.sun.star.awt.XRequestCallback;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.WikiDialog;

public class MainThreadDialogExecutor
implements XCallback {
    private WikiDialog m_aWikiDialog;
    private XDialog m_xDialog;
    private XMessageBox m_xMessageBox;
    private boolean m_bResult = false;
    private boolean m_bCalled = false;
    private boolean m_bClose = false;

    public static boolean Show(XComponentContext xComponentContext, WikiDialog wikiDialog) {
        MainThreadDialogExecutor mainThreadDialogExecutor = new MainThreadDialogExecutor(wikiDialog);
        return MainThreadDialogExecutor.GetCallback(xComponentContext, mainThreadDialogExecutor);
    }

    public static boolean Execute(XComponentContext xComponentContext, XDialog xDialog) {
        MainThreadDialogExecutor mainThreadDialogExecutor = new MainThreadDialogExecutor(xDialog);
        return MainThreadDialogExecutor.GetCallback(xComponentContext, mainThreadDialogExecutor);
    }

    public static boolean Execute(XComponentContext xComponentContext, XMessageBox xMessageBox) {
        MainThreadDialogExecutor mainThreadDialogExecutor = new MainThreadDialogExecutor(xMessageBox);
        return MainThreadDialogExecutor.GetCallback(xComponentContext, mainThreadDialogExecutor);
    }

    public static boolean Close(XComponentContext xComponentContext, XDialog xDialog) {
        MainThreadDialogExecutor mainThreadDialogExecutor = new MainThreadDialogExecutor(xDialog, true);
        return MainThreadDialogExecutor.GetCallback(xComponentContext, mainThreadDialogExecutor);
    }

    private static boolean GetCallback(XComponentContext xComponentContext, MainThreadDialogExecutor mainThreadDialogExecutor) {
        try {
            if (mainThreadDialogExecutor != null) {
                String string = null;
                Thread thread = Thread.currentThread();
                if (thread != null) {
                    string = thread.getName();
                }
                if (string != null && string.equals("com.sun.star.thread.WikiEditorSendingThread")) {
                    XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
                    if (xMultiComponentFactory == null) {
                        throw new RuntimeException();
                    }
                    XRequestCallback xRequestCallback = (XRequestCallback)UnoRuntime.queryInterface(XRequestCallback.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.awt.AsyncCallback", xComponentContext));
                    if (xRequestCallback != null) {
                        xRequestCallback.addCallback((XCallback)mainThreadDialogExecutor, (Object)Any.VOID);
                        do {
                            Thread.yield();
                        } while (!mainThreadDialogExecutor.m_bCalled);
                    }
                } else {
                    mainThreadDialogExecutor.notify(Any.VOID);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return mainThreadDialogExecutor.GetResult();
    }

    private MainThreadDialogExecutor(WikiDialog wikiDialog) {
        this.m_aWikiDialog = wikiDialog;
    }

    private MainThreadDialogExecutor(XDialog xDialog) {
        this.m_xDialog = xDialog;
    }

    private MainThreadDialogExecutor(XDialog xDialog, boolean bl) {
        this.m_xDialog = xDialog;
        this.m_bClose = true;
        this.m_bCalled = true;
    }

    private MainThreadDialogExecutor(XMessageBox xMessageBox) {
        this.m_xMessageBox = xMessageBox;
    }

    private boolean GetResult() {
        return this.m_bResult;
    }

    public void notify(Object object) {
        if (this.m_aWikiDialog != null) {
            this.m_bResult = this.m_aWikiDialog.show();
        } else if (this.m_xDialog != null) {
            if (!this.m_bClose) {
                this.m_bResult = this.m_xDialog.execute() == 1;
            } else {
                try {
                    this.m_xDialog.endExecute();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.m_bResult = true;
            }
        } else if (this.m_xMessageBox != null) {
            short s = this.m_xMessageBox.execute();
            this.m_bResult = s == 1 || s == 2;
        }
        this.m_bCalled = true;
    }
}

