/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.input.style.parser.stylehandler.text;

import java.util.HashMap;
import java.util.Map;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.text.TextStyleKeys;
import org.jfree.layouting.input.style.parser.CSSCompoundValueReadHandler;
import org.jfree.layouting.input.style.parser.CSSValueFactory;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.w3c.css.sac.LexicalUnit;

public abstract class SpacingLimitReadHandler
implements CSSCompoundValueReadHandler {
    public static final CSSConstant NORMAL = new CSSConstant("normal");

    protected SpacingLimitReadHandler() {
    }

    public Map createValues(LexicalUnit lexicalUnit) {
        CSSValue cSSValue = this.parseSingleSpacingValue(lexicalUnit);
        if (cSSValue == null) {
            return null;
        }
        CSSValue cSSValue2 = this.parseSingleSpacingValue(lexicalUnit = lexicalUnit.getNextLexicalUnit());
        if (cSSValue2 != null) {
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
        CSSValue cSSValue3 = this.parseSingleSpacingValue(lexicalUnit);
        HashMap<StyleKey, CSSValue> hashMap = new HashMap<StyleKey, CSSValue>();
        hashMap.put(this.getMinimumKey(), cSSValue2);
        hashMap.put(TextStyleKeys.X_MAX_LETTER_SPACING, cSSValue3);
        hashMap.put(TextStyleKeys.X_OPTIMUM_LETTER_SPACING, cSSValue);
        return hashMap;
    }

    protected abstract StyleKey getMinimumKey();

    protected abstract StyleKey getMaximumKey();

    protected abstract StyleKey getOptimumKey();

    private CSSValue parseSingleSpacingValue(LexicalUnit lexicalUnit) {
        if (lexicalUnit == null) {
            return null;
        }
        if (lexicalUnit.getLexicalUnitType() == 35) {
            if ("normal".equalsIgnoreCase(lexicalUnit.getStringValue())) {
                return NORMAL;
            }
            return null;
        }
        if (lexicalUnit.getLexicalUnitType() == 23) {
            return CSSNumericValue.createValue(CSSNumericType.PERCENTAGE, lexicalUnit.getFloatValue());
        }
        return CSSValueFactory.createLengthValue(lexicalUnit);
    }

    public StyleKey[] getAffectedKeys() {
        return new StyleKey[]{this.getMinimumKey(), this.getMaximumKey(), this.getOptimumKey()};
    }
}

