/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.typing.sequence.NumberSequence;

public class CountAFunction
implements Function {
    public String getCanonicalName() {
        return "COUNTA";
    }

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n = parameterCallback.getParameterCount();
        if (n == 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                Type type = parameterCallback.getType(i);
                Object object = parameterCallback.getValue(i);
                NumberSequence numberSequence = formulaContext.getTypeRegistry().convertToNumberSequence(type, object, false);
                while (numberSequence.hasNext()) {
                    Object object2 = numberSequence.next();
                    if (object2 == null) continue;
                    ++n2;
                }
                continue;
            }
            catch (EvaluationException evaluationException) {
                ++n2;
            }
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(n2));
    }
}

