/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.logical;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.LogicalType;

public class IfFunction
implements Function {
    private static final TypeValuePair RETURN_FALSE = new TypeValuePair(LogicalType.TYPE, Boolean.FALSE);
    private static final long serialVersionUID = -7517668261071087411L;

    public String getCanonicalName() {
        return "IF";
    }

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n = parameterCallback.getParameterCount();
        if (n < 2) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type = parameterCallback.getType(0);
        Object object = parameterCallback.getValue(0);
        Boolean bl = formulaContext.getTypeRegistry().convertToLogical(type, object);
        if (bl == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (Boolean.TRUE.equals(bl)) {
            Object object2 = parameterCallback.getValue(1);
            Type type2 = parameterCallback.getType(1);
            return new TypeValuePair(type2, object2);
        }
        if (n == 2 || parameterCallback.getValue(2) == null) {
            return RETURN_FALSE;
        }
        Object object3 = parameterCallback.getValue(2);
        Type type3 = parameterCallback.getType(2);
        return new TypeValuePair(type3, object3);
    }
}

