/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;

public class EvenFunction
implements Function {
    private static final long serialVersionUID = 2587673708222713810L;

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n = parameterCallback.getParameterCount();
        if (n < 1) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type = parameterCallback.getType(0);
        Object object = parameterCallback.getValue(0);
        Number number = formulaContext.getTypeRegistry().convertToNumber(type, object);
        BigDecimal bigDecimal = EvenFunction.compute(number);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, bigDecimal);
    }

    private static BigDecimal compute(Number number) {
        int n = number.doubleValue() < 0.0 ? (int)Math.floor(number.doubleValue()) : (int)Math.ceil(number.doubleValue());
        BigDecimal bigDecimal = n % 2 == 0 ? (n == 0 ? (number.doubleValue() < 0.0 ? new BigDecimal(-2) : (number.doubleValue() > 0.0 ? new BigDecimal(2) : new BigDecimal(0))) : new BigDecimal(n)) : (number.doubleValue() < 0.0 ? new BigDecimal(n - 1) : new BigDecimal(n + 1));
        return bigDecimal;
    }

    public String getCanonicalName() {
        return "EVEN";
    }
}

