/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class ModFunction
implements Function {
    private static final long serialVersionUID = -2492279311353854670L;

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        Object object;
        Object object2;
        Type type;
        int n = parameterCallback.getParameterCount();
        if (n != 2) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Number number = typeRegistry.convertToNumber(type = parameterCallback.getType(0), object2 = parameterCallback.getValue(0));
        if (number == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        BigDecimal bigDecimal = NumberUtil.getAsBigDecimal(number);
        Type type2 = parameterCallback.getType(1);
        Number number2 = typeRegistry.convertToNumber(type2, object = parameterCallback.getValue(1));
        if (number2 == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        BigDecimal bigDecimal2 = NumberUtil.getAsBigDecimal(number2);
        if (bigDecimal2.signum() == 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARITHMETIC_VALUE);
        }
        BigDecimal bigDecimal3 = new BigDecimal(bigDecimal.divide(bigDecimal2, 0, 3).toString());
        BigDecimal bigDecimal4 = bigDecimal.subtract(bigDecimal2.multiply(bigDecimal3));
        if (bigDecimal3.signum() == 0 && (bigDecimal.signum() == -1 && bigDecimal2.signum() != -1 || bigDecimal2.signum() == -1 && bigDecimal.signum() != -1)) {
            bigDecimal4 = bigDecimal.add(bigDecimal2);
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, bigDecimal4);
    }

    public String getCanonicalName() {
        return "MOD";
    }
}

