/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.function.text.MidFunction;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class RightFunction
implements Function {
    private static final long serialVersionUID = 1637903638146059530L;

    public TypeValuePair evaluate(FormulaContext formulaContext, ParameterCallback parameterCallback) throws EvaluationException {
        int n;
        int n2 = parameterCallback.getParameterCount();
        if (n2 < 1 || n2 > 2) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = formulaContext.getTypeRegistry();
        Type type = parameterCallback.getType(0);
        Object object = parameterCallback.getValue(0);
        String string = typeRegistry.convertToText(type, object);
        if (n2 == 2) {
            Number number = typeRegistry.convertToNumber(parameterCallback.getType(1), parameterCallback.getValue(1));
            if (number.doubleValue() < 0.0) {
                throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            n = number.intValue();
        } else {
            n = 1;
        }
        if (string == null || n < 0) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        int n3 = string.length() - n + 1;
        if (n3 < 1) {
            n3 = 1;
        }
        return new TypeValuePair(TextType.TYPE, MidFunction.process(string, n3, n));
    }

    public String getCanonicalName() {
        return "RIGHT";
    }
}

