/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.lvalues;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.FunctionDescription;
import org.pentaho.reporting.libraries.formula.function.FunctionRegistry;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.AbstractLValue;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;

public class FormulaFunction
extends AbstractLValue {
    private static final Log logger = LogFactory.getLog(FormulaFunction.class);
    private String functionName;
    private LValue[] parameters;
    private Function function;
    private FunctionDescription metaData;
    private static final long serialVersionUID = 8023588016882997962L;

    public FormulaFunction(String string, LValue[] lValueArray, ParsePosition parsePosition) {
        this.functionName = string;
        this.setParsePosition(parsePosition);
        this.parameters = (LValue[])lValueArray.clone();
    }

    public FormulaFunction(String string, LValue[] lValueArray) {
        this(string, lValueArray, null);
    }

    public void initialize(FormulaContext formulaContext) throws EvaluationException {
        super.initialize(formulaContext);
        FunctionRegistry functionRegistry = formulaContext.getFunctionRegistry();
        this.function = functionRegistry.createFunction(this.functionName);
        this.metaData = functionRegistry.getMetaData(this.functionName);
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i] == null) continue;
            this.parameters[i].initialize(formulaContext);
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Function getFunction() {
        return this.function;
    }

    public FunctionDescription getMetaData() {
        return this.metaData;
    }

    public Object clone() throws CloneNotSupportedException {
        FormulaFunction formulaFunction = (FormulaFunction)super.clone();
        formulaFunction.parameters = (LValue[])this.parameters.clone();
        for (int i = 0; i < this.parameters.length; ++i) {
            LValue lValue = this.parameters[i];
            formulaFunction.parameters[i] = (LValue)lValue.clone();
        }
        return formulaFunction;
    }

    public TypeValuePair evaluate() throws EvaluationException {
        FormulaContext formulaContext = this.getContext();
        if (this.function == null) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_FUNCTION_VALUE);
        }
        try {
            return this.function.evaluate(formulaContext, new FormulaParameterCallback(this));
        }
        catch (EvaluationException evaluationException) {
            throw evaluationException;
        }
        catch (Exception exception) {
            logger.error((Object)"Unexpected exception while evaluating", (Throwable)exception);
            throw new EvaluationException(LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
    }

    public LValue[] getChildValues() {
        return (LValue[])this.parameters.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.functionName);
        stringBuffer.append('(');
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i > 0) {
                stringBuffer.append(';');
            }
            LValue lValue = this.parameters[i];
            stringBuffer.append(lValue);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public boolean isConstant() {
        if (this.metaData.isVolatile()) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            LValue lValue = this.parameters[i];
            if (lValue.isConstant()) continue;
            return false;
        }
        return true;
    }

    private static class FormulaParameterCallback
    implements ParameterCallback {
        private TypeValuePair[] backend;
        private FormulaFunction function;

        private FormulaParameterCallback(FormulaFunction formulaFunction) {
            this.function = formulaFunction;
            this.backend = new TypeValuePair[formulaFunction.parameters.length];
        }

        private TypeValuePair get(int n) throws EvaluationException {
            LValue lValue = this.function.parameters[n];
            Type type = this.function.metaData.getParameterType(n);
            if (lValue != null) {
                TypeValuePair typeValuePair = lValue.evaluate();
                TypeRegistry typeRegistry = this.function.getContext().getTypeRegistry();
                TypeValuePair typeValuePair2 = typeRegistry.convertTo(type, typeValuePair);
                if (typeValuePair2 == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Failed to evaluate parameter " + n + " on function " + this.function));
                    }
                    throw new EvaluationException(LibFormulaErrorValue.ERROR_INVALID_AUTO_ARGUMENT_VALUE);
                }
                return typeValuePair2;
            }
            return new TypeValuePair(type, this.function.metaData.getDefaultValue(n));
        }

        public LValue getRaw(int n) {
            return this.function.parameters[n];
        }

        public Object getValue(int n) throws EvaluationException {
            TypeValuePair typeValuePair;
            TypeValuePair typeValuePair2 = this.backend[n];
            if (typeValuePair2 != null) {
                return typeValuePair2.getValue();
            }
            this.backend[n] = typeValuePair = this.get(n);
            return typeValuePair.getValue();
        }

        public Type getType(int n) throws EvaluationException {
            TypeValuePair typeValuePair;
            TypeValuePair typeValuePair2 = this.backend[n];
            if (typeValuePair2 != null) {
                return typeValuePair2.getType();
            }
            this.backend[n] = typeValuePair = this.get(n);
            return typeValuePair.getType();
        }

        public int getParameterCount() {
            return this.backend.length;
        }
    }
}

