/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.typing.sequence;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.LValue;
import org.pentaho.reporting.libraries.formula.lvalues.StaticValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.ArrayCallback;
import org.pentaho.reporting.libraries.formula.typing.Sequence;

public class AnySequence
implements Sequence {
    private int rowCursor;
    private int columnCursor;
    private LValue single;
    private ArrayCallback array;
    private FormulaContext context;

    public AnySequence(FormulaContext formulaContext) {
        if (formulaContext == null) {
            throw new NullPointerException();
        }
        this.context = formulaContext;
    }

    public AnySequence(ArrayCallback arrayCallback, FormulaContext formulaContext) {
        if (formulaContext == null) {
            throw new NullPointerException();
        }
        if (arrayCallback == null) {
            throw new NullPointerException();
        }
        this.array = arrayCallback;
        this.context = formulaContext;
    }

    public AnySequence(LValue lValue, FormulaContext formulaContext) {
        if (formulaContext == null) {
            throw new NullPointerException();
        }
        if (lValue == null) {
            throw new NullPointerException();
        }
        this.single = lValue;
        this.context = formulaContext;
    }

    protected AnySequence(AnySequence anySequence) {
        this.single = anySequence.single;
        this.context = anySequence.context;
        this.array = anySequence.array;
        this.rowCursor = anySequence.rowCursor;
        this.columnCursor = anySequence.columnCursor;
    }

    public boolean hasNext() throws EvaluationException {
        if (this.single == null && this.array == null) {
            return false;
        }
        if (this.single != null && this.rowCursor == 0) {
            return this.isValidNext(this.single);
        }
        if (this.array != null) {
            int n = this.array.getRowCount();
            int n2 = this.array.getColumnCount();
            if (this.rowCursor < n && this.columnCursor < n2) {
                while (this.rowCursor < n) {
                    while (this.columnCursor < n2) {
                        LValue lValue = this.array.getRaw(this.rowCursor, this.columnCursor);
                        if (this.isValidNext(lValue)) {
                            return true;
                        }
                        ++this.columnCursor;
                    }
                    ++this.rowCursor;
                }
                this.columnCursor = 0;
            }
        }
        return false;
    }

    protected boolean isValidNext(LValue lValue) {
        return lValue != null;
    }

    public Object next() throws EvaluationException {
        if (this.single != null && this.rowCursor == 0) {
            ++this.rowCursor;
            TypeValuePair typeValuePair = this.single.evaluate();
            return typeValuePair.getValue();
        }
        if (this.array != null) {
            Object object = this.array.getValue(this.rowCursor, this.columnCursor);
            if (this.columnCursor == this.array.getColumnCount() - 1) {
                ++this.rowCursor;
                this.columnCursor = 0;
            } else {
                ++this.columnCursor;
            }
            return object;
        }
        return null;
    }

    public LValue nextRawValue() throws EvaluationException {
        if (this.single != null && this.rowCursor == 0) {
            ++this.rowCursor;
            return new StaticValue(this.single);
        }
        if (this.array != null) {
            LValue lValue = this.array.getRaw(this.rowCursor, this.columnCursor);
            if (this.columnCursor == this.array.getColumnCount() - 1) {
                ++this.rowCursor;
                this.columnCursor = 0;
            } else {
                ++this.columnCursor;
            }
            return lValue;
        }
        return null;
    }

    protected int getRowCursor() {
        return this.rowCursor;
    }

    protected int getColumnCursor() {
        return this.columnCursor;
    }

    protected LValue getSingle() {
        return this.single;
    }

    protected ArrayCallback getArray() {
        return this.array;
    }

    protected FormulaContext getContext() {
        return this.context;
    }
}

