/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.boot;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.boot.PackageManager;
import org.pentaho.reporting.libraries.base.boot.SubSystem;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfiguration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfigurationWrapper;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.config.PropertyFileConfiguration;
import org.pentaho.reporting.libraries.base.config.SystemPropertyConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.versioning.DependencyInformation;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

public abstract class AbstractBoot
implements SubSystem {
    private ExtendedConfigurationWrapper extWrapper;
    private PackageManager packageManager;
    private Configuration globalConfig;
    private boolean bootInProgress;
    private boolean bootDone;
    private Exception bootFailed;
    private static final Log LOGGER = LogFactory.getLog(AbstractBoot.class);

    protected AbstractBoot() {
    }

    public synchronized PackageManager getPackageManager() {
        if (this.packageManager == null) {
            this.packageManager = new PackageManager(this);
        }
        return this.packageManager;
    }

    public synchronized Configuration getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = this.loadConfiguration();
        }
        return this.globalConfig;
    }

    public final synchronized boolean isBootInProgress() {
        return this.bootInProgress;
    }

    public final synchronized boolean isBootDone() {
        return this.bootDone;
    }

    protected abstract Configuration loadConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this;
        synchronized (object) {
            if (this.isBootDone()) {
                return;
            }
            if (this.isBootFailed()) {
                LOGGER.error((Object)(this.getClass() + " failed to boot: " + this.bootFailed.getMessage()));
            }
            while (this.isBootInProgress()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.isBootDone()) {
                this.notifyAll();
                return;
            }
            this.bootInProgress = true;
        }
        try {
            object = this.getProjectInfo();
            if (object != null) {
                this.performBootDependencies(((ProjectInformation)object).getLibraries());
                this.performBootDependencies(((ProjectInformation)object).getOptionalLibraries());
            }
            this.performBoot();
            if (object != null) {
                LOGGER.info((Object)(((DependencyInformation)object).getName() + ' ' + ((ProjectInformation)object).getVersion() + " started."));
            } else {
                LOGGER.info((Object)(this.getClass() + " started."));
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)(this.getClass() + " failed to boot: "), (Throwable)exception);
            this.bootFailed = exception;
        }
        finally {
            AbstractBoot abstractBoot = this;
            synchronized (abstractBoot) {
                this.bootInProgress = false;
                this.bootDone = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performBootDependencies(DependencyInformation[] dependencyInformationArray) {
        if (dependencyInformationArray == null) {
            return;
        }
        for (int i = 0; i < dependencyInformationArray.length; ++i) {
            ProjectInformation projectInformation;
            AbstractBoot abstractBoot;
            DependencyInformation dependencyInformation = dependencyInformationArray[i];
            if (!(dependencyInformation instanceof ProjectInformation) || (abstractBoot = this.loadBooter((projectInformation = (ProjectInformation)dependencyInformation).getBootClass())) == null) continue;
            AbstractBoot abstractBoot2 = abstractBoot;
            synchronized (abstractBoot2) {
                abstractBoot.start();
                while (!abstractBoot.isBootDone() && !abstractBoot.isBootFailed()) {
                    try {
                        abstractBoot.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (abstractBoot.isBootFailed()) {
                    this.bootFailed = abstractBoot.getBootFailureReason();
                    LOGGER.error((Object)("Dependent project failed to boot up: " + projectInformation.getBootClass() + " failed to boot: "), (Throwable)abstractBoot.getBootFailureReason());
                    return;
                }
                continue;
            }
        }
    }

    public boolean isBootFailed() {
        return this.bootFailed != null;
    }

    public Exception getBootFailureReason() {
        return this.bootFailed;
    }

    protected abstract void performBoot();

    protected abstract ProjectInformation getProjectInfo();

    protected AbstractBoot loadBooter(String string) {
        return AbstractBoot.loadBooter(string, this.getClass());
    }

    public static AbstractBoot loadBooter(String string, Class clazz) {
        if (string == null) {
            return null;
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
        try {
            Class<?> clazz2 = ObjectUtilities.getClassLoader(clazz).loadClass(string);
            Method method = clazz2.getMethod("getInstance", null);
            return (AbstractBoot)method.invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            LOGGER.info((Object)("Unable to boot dependent class: " + string));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Configuration createDefaultHierarchicalConfiguration(String string, String string2, boolean bl, Class clazz) {
        Object object;
        if (clazz == null) {
            throw new NullPointerException("SourceClass must not be null.");
        }
        HierarchicalConfiguration hierarchicalConfiguration = new HierarchicalConfiguration(this.getClass());
        if (string != null) {
            object = new PropertyFileConfiguration();
            ((PropertyFileConfiguration)object).load(string, clazz);
            hierarchicalConfiguration.insertConfiguration((HierarchicalConfiguration)object);
            hierarchicalConfiguration.insertConfiguration(this.getPackageManager().getPackageConfiguration());
        }
        if (string2 != null) {
            object = string2.charAt(0) == '/' ? string2.substring(1) : string2;
            try {
                PropertyFileConfiguration propertyFileConfiguration;
                Enumeration<URL> enumeration = ObjectUtilities.getClassLoader(clazz).getResources((String)object);
                ArrayList<PropertyFileConfiguration> arrayList = new ArrayList<PropertyFileConfiguration>();
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    try {
                        propertyFileConfiguration = new PropertyFileConfiguration();
                        InputStream inputStream = uRL.openStream();
                        try {
                            propertyFileConfiguration.load(inputStream);
                        }
                        finally {
                            inputStream.close();
                        }
                        arrayList.add(propertyFileConfiguration);
                    }
                    catch (IOException iOException) {
                        LOGGER.warn((Object)("Failed to load the user configuration at " + uRL), (Throwable)iOException);
                    }
                }
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    propertyFileConfiguration = (PropertyFileConfiguration)arrayList.get(i);
                    hierarchicalConfiguration.insertConfiguration(propertyFileConfiguration);
                }
            }
            catch (IOException iOException) {
                LOGGER.warn((Object)"Failed to lookup the user configurations.", (Throwable)iOException);
            }
        }
        if (bl) {
            object = new SystemPropertyConfiguration();
            hierarchicalConfiguration.insertConfiguration((HierarchicalConfiguration)object);
        }
        return hierarchicalConfiguration;
    }

    public synchronized ExtendedConfiguration getExtendedConfig() {
        if (this.extWrapper == null) {
            this.extWrapper = new ExtendedConfigurationWrapper(this.getGlobalConfig());
        }
        return this.extWrapper;
    }
}

