/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.boot;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializeException;
import org.pentaho.reporting.libraries.base.boot.SubSystem;

public class PackageState {
    private static final Log LOGGER = LogFactory.getLog(PackageState.class);
    public static final int STATE_NEW = 0;
    public static final int STATE_CONFIGURED = 1;
    public static final int STATE_INITIALIZED = 2;
    public static final int STATE_ERROR = -2;
    private final Module module;
    private int state;

    public PackageState(Module module) {
        this(module, 0);
    }

    public PackageState(Module module, int n) {
        if (module == null) {
            throw new NullPointerException("Module must not be null.");
        }
        if (n != 1 && n != -2 && n != 2 && n != 0) {
            throw new IllegalArgumentException("State is not valid");
        }
        this.module = module;
        this.state = n;
    }

    public boolean configure(SubSystem subSystem) {
        if (subSystem == null) {
            throw new NullPointerException();
        }
        if (this.state == 0) {
            try {
                this.module.configure(subSystem);
                this.state = 1;
                return true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                LOGGER.warn((Object)("Unable to load module classes for " + this.module.getName() + ':' + noClassDefFoundError.getMessage()));
                this.state = -2;
            }
            catch (Exception exception) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn((Object)("Unable to configure the module " + this.module.getName()), (Throwable)exception);
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("Unable to configure the module " + this.module.getName()));
                }
                this.state = -2;
            }
        }
        return false;
    }

    public Module getModule() {
        return this.module;
    }

    public int getState() {
        return this.state;
    }

    public boolean initialize(SubSystem subSystem) {
        if (subSystem == null) {
            throw new NullPointerException();
        }
        if (this.state == 1) {
            try {
                this.module.initialize(subSystem);
                this.state = 2;
                return true;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                LOGGER.warn((Object)("Unable to load module classes for " + this.module.getName() + ':' + noClassDefFoundError.getMessage()));
                this.state = -2;
            }
            catch (ModuleInitializeException moduleInitializeException) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn((Object)("Unable to initialize the module " + this.module.getName()), (Throwable)moduleInitializeException);
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("Unable to initialize the module " + this.module.getName()));
                }
                this.state = -2;
            }
            catch (Exception exception) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.warn((Object)("Unable to initialize the module " + this.module.getName()), (Throwable)exception);
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn((Object)("Unable to initialize the module " + this.module.getName()));
                }
                this.state = -2;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PackageState)) {
            return false;
        }
        PackageState packageState = (PackageState)object;
        return this.module.getModuleClass().equals(packageState.module.getModuleClass());
    }

    public int hashCode() {
        return this.module.hashCode();
    }

    public void markError() {
        this.state = -2;
    }
}

