/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.config;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;

public class HierarchicalConfiguration
implements ModifiableConfiguration {
    private static final long serialVersionUID = -6962432361197107831L;
    private Properties configuration = new Properties();
    private Class booterClass;
    private transient Configuration parentConfiguration;

    public HierarchicalConfiguration() {
    }

    public HierarchicalConfiguration(Configuration configuration) {
        this();
        this.parentConfiguration = configuration;
    }

    public HierarchicalConfiguration(Class clazz) {
        this();
        this.booterClass = clazz;
    }

    public String getConfigProperty(String string) {
        return this.getConfigProperty(string, null);
    }

    public String getConfigProperty(String string, String string2) {
        String string3 = this.configuration.getProperty(string);
        if (string3 == null) {
            string3 = this.isRootConfig() ? string2 : this.parentConfiguration.getConfigProperty(string, string2);
        }
        return string3;
    }

    public void setConfigProperty(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            this.configuration.remove(string);
        } else {
            this.configuration.setProperty(string, string2);
        }
    }

    private boolean isRootConfig() {
        return this.parentConfiguration == null;
    }

    public boolean isLocallyDefined(String string) {
        return this.configuration.containsKey(string);
    }

    protected Properties getConfiguration() {
        return this.configuration;
    }

    public void insertConfiguration(HierarchicalConfiguration hierarchicalConfiguration) {
        if (hierarchicalConfiguration == null) {
            throw new NullPointerException("Configuration that should be inserted is null");
        }
        hierarchicalConfiguration.setParentConfig(this.getParentConfig());
        this.setParentConfig(hierarchicalConfiguration);
    }

    protected void setParentConfig(Configuration configuration) {
        if (this.parentConfiguration == this) {
            throw new IllegalArgumentException("Cannot add myself as parent configuration.");
        }
        this.parentConfiguration = configuration;
    }

    protected Configuration getParentConfig() {
        return this.parentConfiguration;
    }

    public Enumeration getConfigProperties() {
        return this.configuration.keys();
    }

    public Iterator findPropertyKeys(String string) {
        if (string == null) {
            throw new NullPointerException("Prefix must not be null");
        }
        HashSet hashSet = new HashSet();
        this.collectPropertyKeys(string, this, hashSet);
        Object[] objectArray = hashSet.toArray();
        Arrays.sort(objectArray);
        return Arrays.asList(objectArray).iterator();
    }

    private void collectPropertyKeys(String string, Configuration configuration, Set set) {
        Object object;
        Enumeration enumeration = configuration.getConfigProperties();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            if (!((String)object).startsWith(string) || set.contains(object)) continue;
            set.add(object);
        }
        if (configuration instanceof HierarchicalConfiguration) {
            object = (HierarchicalConfiguration)configuration;
            if (((HierarchicalConfiguration)object).parentConfiguration != null) {
                this.collectPropertyKeys(string, ((HierarchicalConfiguration)object).parentConfiguration, set);
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.parentConfiguration instanceof HierarchicalConfiguration) {
            HierarchicalConfiguration hierarchicalConfiguration = (HierarchicalConfiguration)this.parentConfiguration;
            if (hierarchicalConfiguration.booterClass != null) {
                objectOutputStream.writeBoolean(false);
            } else {
                objectOutputStream.writeBoolean(true);
                objectOutputStream.writeObject(this.parentConfiguration);
            }
        } else if (this.parentConfiguration != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.parentConfiguration);
        } else {
            objectOutputStream.writeBoolean(false);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            this.parentConfiguration = (ModifiableConfiguration)objectInputStream.readObject();
        } else if (this.booterClass != null) {
            AbstractBoot abstractBoot = AbstractBoot.loadBooter(this.booterClass.getName(), this.booterClass);
            this.parentConfiguration = abstractBoot.getGlobalConfig();
        } else {
            this.parentConfiguration = null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        HierarchicalConfiguration hierarchicalConfiguration = (HierarchicalConfiguration)super.clone();
        hierarchicalConfiguration.configuration = (Properties)this.configuration.clone();
        return hierarchicalConfiguration;
    }
}

