/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.config;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class PropertyFileConfiguration
extends HierarchicalConfiguration {
    private static final Log LOGGER = LogFactory.getLog(PropertyFileConfiguration.class);
    private static final long serialVersionUID = 2423181637547944866L;

    public void load(String string) {
        this.load(string, PropertyFileConfiguration.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string, Class clazz) {
        InputStream inputStream = ObjectUtilities.getResourceRelativeAsStream(string, clazz);
        if (inputStream != null) {
            try {
                this.load(inputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        LOGGER.debug((Object)("Configuration file not found in the classpath: " + string));
    }

    public void load(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            this.getConfiguration().putAll((Map<?, ?>)properties);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            LOGGER.warn((Object)"Unable to read configuration", (Throwable)iOException);
        }
    }
}

