/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.util.HashMap;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.resourceloader.DependencyCollector;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.xmlns.parser.CommentHandler;
import org.pentaho.reporting.libraries.xmlns.parser.FixNamespaceUriAttributes;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RootXmlReadHandler
extends DefaultHandler {
    private DefaultConfiguration parserConfiguration;
    private Locator documentLocator;
    private FastStack currentHandlers;
    private FastStack outerScopes;
    private XmlReadHandler rootHandler;
    private HashMap objectRegistry;
    private boolean rootHandlerInitialized;
    private CommentHandler commentHandler;
    private DependencyCollector dependencyCollector;
    private ResourceKey source;
    private ResourceKey context;
    private ResourceManager manager;
    private FastStack namespaces;
    private boolean firstCall;

    public RootXmlReadHandler(ResourceManager resourceManager, ResourceKey resourceKey, long l) {
        this(resourceManager, resourceKey, resourceKey, l);
    }

    public RootXmlReadHandler(ResourceManager resourceManager, ResourceKey resourceKey, ResourceKey resourceKey2, long l) {
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        this.firstCall = true;
        this.manager = resourceManager;
        this.source = resourceKey;
        this.context = resourceKey2;
        this.dependencyCollector = new DependencyCollector(resourceKey, l);
        this.objectRegistry = new HashMap();
        this.parserConfiguration = new DefaultConfiguration();
        this.commentHandler = new CommentHandler();
        this.namespaces = new FastStack();
    }

    public ResourceKey getContext() {
        return this.context;
    }

    public ResourceManager getResourceManager() {
        return this.manager;
    }

    public boolean isFirstCall() {
        return this.firstCall;
    }

    public ResourceKey getSource() {
        return this.source;
    }

    public DependencyCollector getDependencyCollector() {
        return this.dependencyCollector;
    }

    public CommentHandler getCommentHandler() {
        return this.commentHandler;
    }

    public DefaultConfiguration getParserConfiguration() {
        return this.parserConfiguration;
    }

    public void setDocumentLocator(Locator locator) {
        this.documentLocator = locator;
    }

    public Locator getDocumentLocator() {
        return this.documentLocator;
    }

    public void setHelperObject(String string, Object object) {
        if (object == null) {
            this.objectRegistry.remove(string);
        } else {
            this.objectRegistry.put(string, object);
        }
    }

    public Object getHelperObject(String string) {
        return this.objectRegistry.get(string);
    }

    public String[] getHelperObjectNames() {
        return this.objectRegistry.keySet().toArray(new String[this.objectRegistry.size()]);
    }

    protected void setRootHandler(XmlReadHandler xmlReadHandler) {
        if (xmlReadHandler == null) {
            throw new NullPointerException();
        }
        this.rootHandler = xmlReadHandler;
        this.rootHandlerInitialized = false;
    }

    protected XmlReadHandler getRootHandler() {
        return this.rootHandler;
    }

    public void recurse(XmlReadHandler xmlReadHandler, String string, String string2, Attributes attributes) throws SAXException {
        if (xmlReadHandler == null) {
            throw new NullPointerException();
        }
        this.outerScopes.push((Object)this.currentHandlers);
        this.currentHandlers = new FastStack();
        this.currentHandlers.push((Object)xmlReadHandler);
        xmlReadHandler.startElement(string, string2, attributes);
    }

    public void delegate(XmlReadHandler xmlReadHandler, String string, String string2, Attributes attributes) throws SAXException {
        if (xmlReadHandler == null) {
            throw new NullPointerException();
        }
        this.currentHandlers.push((Object)xmlReadHandler);
        xmlReadHandler.init(this, string, string2);
        xmlReadHandler.startElement(string, string2, attributes);
    }

    public void unwind(String string, String string2) throws SAXException {
        this.currentHandlers.pop();
        if (this.currentHandlers.isEmpty() && !this.outerScopes.isEmpty()) {
            this.currentHandlers = (FastStack)this.outerScopes.pop();
        } else if (!this.currentHandlers.isEmpty()) {
            this.getCurrentHandler().endElement(string, string2);
        }
    }

    protected XmlReadHandler getCurrentHandler() {
        return (XmlReadHandler)this.currentHandlers.peek();
    }

    public void startDocument() throws SAXException {
        this.outerScopes = new FastStack();
        this.currentHandlers = new FastStack();
        if (this.rootHandler != null) {
            this.currentHandlers.push((Object)this.rootHandler);
        }
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.firstCall) {
            this.firstCall = false;
            this.interceptFirstStartElement(string, string2, string3, attributes);
            return;
        }
        String string4 = attributes.getValue("xmlns");
        String string5 = string4 != null ? string4 : (this.namespaces.isEmpty() ? "" : (String)this.namespaces.peek());
        this.pushDefaultNamespace(string5);
        String string6 = (string == null || "".equals(string)) && string5 != null ? string5 : string;
        if (!this.rootHandlerInitialized) {
            this.rootHandler.init(this, string6, string2);
            this.rootHandlerInitialized = true;
        }
        XmlReadHandler xmlReadHandler = this.getCurrentHandler();
        xmlReadHandler.startElement(string6, string2, this.wrapAttributes(new FixNamespaceUriAttributes(string6, attributes)));
    }

    protected Attributes wrapAttributes(Attributes attributes) {
        return attributes;
    }

    protected void interceptFirstStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.startElement(string, string2, string3, attributes);
    }

    protected final void pushDefaultNamespace(String string) {
        this.namespaces.push((Object)string);
    }

    protected void installRootHandler(XmlReadHandler xmlReadHandler, String string, String string2, Attributes attributes) throws SAXException {
        if (xmlReadHandler == null) {
            throw new NullPointerException();
        }
        this.rootHandler = xmlReadHandler;
        this.rootHandler.init(this, string, string2);
        this.currentHandlers.push((Object)xmlReadHandler);
        this.rootHandlerInitialized = true;
        this.rootHandler.startElement(string, string2, attributes);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.getCurrentHandler().characters(cArray, n, n2);
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw new ParseException("Failed at handling character data", exception, this.getDocumentLocator());
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = (String)this.namespaces.pop();
        String string5 = (string == null || "".equals(string)) && string4 != null ? string4 : string;
        XmlReadHandler xmlReadHandler = this.getCurrentHandler();
        xmlReadHandler.endElement(string5, string2);
    }

    public Object getResult() throws SAXException {
        if (this.rootHandler != null) {
            return this.rootHandler.getObject();
        }
        return null;
    }
}

