/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DeclaredNamespaces;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;

public class XmlWriterSupport {
    public static final int OPEN_TAG_INCREASE = 1;
    public static final int CLOSE_TAG_DECREASE = 2;
    public static final int INDENT_ONLY = 3;
    public static final boolean CLOSE = true;
    public static final boolean OPEN = false;
    private TagDescription safeTags;
    private FastStack openTags;
    private String indentString;
    private boolean lineEmpty;
    private int additionalIndent;
    private boolean alwaysAddNamespace;
    private boolean assumeDefaultNamespace;
    private HashMap impliedNamespaces;
    private boolean writeFinalLinebreak;
    private boolean htmlCompatiblityMode;
    private String lineSeparator;
    private StringBuffer normalizeBuffer;

    public XmlWriterSupport() {
        this(new DefaultTagDescription(), "  ");
    }

    public XmlWriterSupport(TagDescription tagDescription, String string) {
        this(tagDescription, string, StringUtils.getLineSeparator());
    }

    public XmlWriterSupport(TagDescription tagDescription, String string, String string2) {
        if (string == null) {
            throw new NullPointerException("IndentString must not be null");
        }
        if (tagDescription == null) {
            throw new NullPointerException("SafeTags must not be null");
        }
        if (string2 == null) {
            throw new NullPointerException("LineSeparator must not be null");
        }
        this.normalizeBuffer = new StringBuffer(128);
        this.safeTags = tagDescription;
        this.openTags = new FastStack();
        this.indentString = string;
        this.lineEmpty = true;
        this.writeFinalLinebreak = true;
        this.lineSeparator = string2;
    }

    public boolean isHtmlCompatiblityMode() {
        return this.htmlCompatiblityMode;
    }

    public void setHtmlCompatiblityMode(boolean bl) {
        this.htmlCompatiblityMode = bl;
    }

    public boolean isAlwaysAddNamespace() {
        return this.alwaysAddNamespace;
    }

    public void setAlwaysAddNamespace(boolean bl) {
        this.alwaysAddNamespace = bl;
    }

    public int getAdditionalIndent() {
        return this.additionalIndent;
    }

    public void setAdditionalIndent(int n) {
        this.additionalIndent = n;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void writeTag(Writer writer, String string, String string2) throws IOException {
        this.writeTag(writer, string, string2, null, false);
    }

    public void writeCloseTag(Writer writer) throws IOException {
        this.indentForClose(writer);
        ElementLevel elementLevel = (ElementLevel)this.openTags.pop();
        this.setLineEmpty(false);
        writer.write("</");
        String string = elementLevel.getPrefix();
        if (string != null) {
            writer.write(string);
            writer.write(":");
            writer.write(elementLevel.getTagName());
        } else {
            writer.write(elementLevel.getTagName());
        }
        writer.write(">");
        this.doEndOfLine(writer);
    }

    public void writeNewLine(Writer writer) throws IOException {
        if (!this.isLineEmpty()) {
            writer.write(this.lineSeparator);
            this.setLineEmpty(true);
        }
    }

    public boolean isLineEmpty() {
        return this.lineEmpty;
    }

    public void setLineEmpty(boolean bl) {
        this.lineEmpty = bl;
    }

    public void writeTag(Writer writer, String string, String string2, String string3, String string4, boolean bl) throws IOException {
        if (string3 != null) {
            AttributeList attributeList = new AttributeList();
            attributeList.setAttribute(string, string3, string4);
            this.writeTag(writer, string, string2, attributeList, bl);
        } else {
            this.writeTag(writer, string, string2, null, bl);
        }
    }

    public void addImpliedNamespace(String string, String string2) {
        if (!this.openTags.isEmpty()) {
            throw new IllegalStateException("Cannot modify the implied namespaces in the middle of the processing");
        }
        if (string2 == null) {
            if (this.impliedNamespaces == null) {
                return;
            }
            this.impliedNamespaces.remove(string);
        } else {
            if (this.impliedNamespaces == null) {
                this.impliedNamespaces = new HashMap();
            }
            this.impliedNamespaces.put(string, string2);
        }
    }

    public void copyNamespaces(XmlWriterSupport xmlWriterSupport) {
        if (!this.openTags.isEmpty()) {
            throw new IllegalStateException("Cannot modify the implied namespaces in the middle of the processing");
        }
        if (this.impliedNamespaces == null) {
            this.impliedNamespaces = new HashMap();
        }
        if (!xmlWriterSupport.openTags.isEmpty()) {
            ElementLevel elementLevel = (ElementLevel)xmlWriterSupport.openTags.peek();
            this.impliedNamespaces.putAll(elementLevel.getNamespaces().getNamespaces());
        }
        if (xmlWriterSupport.impliedNamespaces != null) {
            this.impliedNamespaces.putAll(xmlWriterSupport.impliedNamespaces);
        }
    }

    public boolean isNamespaceDefined(String string) {
        if (this.impliedNamespaces != null && this.impliedNamespaces.containsKey(string)) {
            return true;
        }
        if (this.openTags.isEmpty()) {
            return false;
        }
        ElementLevel elementLevel = (ElementLevel)this.openTags.peek();
        return elementLevel.getNamespaces().isNamespaceDefined(string);
    }

    public boolean isNamespacePrefixDefined(String string) {
        if (this.impliedNamespaces != null && this.impliedNamespaces.containsValue(string)) {
            return true;
        }
        if (this.openTags.isEmpty()) {
            return false;
        }
        ElementLevel elementLevel = (ElementLevel)this.openTags.peek();
        return elementLevel.getNamespaces().isPrefixDefined(string);
    }

    public Properties getNamespaces() {
        Properties properties = new Properties();
        if (this.openTags.isEmpty()) {
            if (this.impliedNamespaces != null) {
                properties.putAll((Map<?, ?>)this.impliedNamespaces);
            }
            return properties;
        }
        ElementLevel elementLevel = (ElementLevel)this.openTags.peek();
        properties.putAll((Map<?, ?>)elementLevel.getNamespaces().getNamespaces());
        return properties;
    }

    protected DeclaredNamespaces computeNamespaces() {
        if (this.openTags.isEmpty()) {
            DeclaredNamespaces declaredNamespaces = new DeclaredNamespaces();
            if (this.impliedNamespaces != null) {
                return declaredNamespaces.add(this.impliedNamespaces);
            }
            return declaredNamespaces;
        }
        ElementLevel elementLevel = (ElementLevel)this.openTags.peek();
        return elementLevel.getNamespaces();
    }

    public void writeTag(Writer writer, String string, String string2, AttributeList attributeList, boolean bl) throws IOException {
        AttributeList.AttributeEntry[] attributeEntryArray;
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.indent(writer);
        this.setLineEmpty(false);
        DeclaredNamespaces declaredNamespaces = this.computeNamespaces();
        if (attributeList != null) {
            declaredNamespaces = declaredNamespaces.add(attributeList);
        }
        writer.write("<");
        if (string == null) {
            writer.write(string2);
            this.openTags.push((Object)new ElementLevel(string2, declaredNamespaces));
        } else {
            attributeEntryArray = declaredNamespaces.getPrefix(string);
            if (attributeEntryArray == null) {
                throw new IllegalArgumentException("Namespace " + string + " is not defined.");
            }
            if ("".equals(attributeEntryArray)) {
                writer.write(string2);
                this.openTags.push((Object)new ElementLevel(string, null, string2, declaredNamespaces));
            } else {
                writer.write((String)attributeEntryArray);
                writer.write(":");
                writer.write(string2);
                this.openTags.push((Object)new ElementLevel(string, (String)attributeEntryArray, string2, declaredNamespaces));
            }
        }
        if (attributeList != null) {
            attributeEntryArray = attributeList.toArray();
            for (int i = 0; i < attributeEntryArray.length; ++i) {
                AttributeList.AttributeEntry attributeEntry = attributeEntryArray[i];
                writer.write(" ");
                this.buildAttributeName(attributeEntry, declaredNamespaces, writer);
                writer.write("=\"");
                this.writeTextNormalized(writer, attributeEntry.getValue(), true);
                writer.write("\"");
            }
        }
        if (bl) {
            if (this.isHtmlCompatiblityMode()) {
                writer.write(" />");
            } else {
                writer.write("/>");
            }
            this.openTags.pop();
            this.doEndOfLine(writer);
        } else {
            writer.write(">");
            this.doEndOfLine(writer);
        }
    }

    private void doEndOfLine(Writer writer) throws IOException {
        if (this.openTags.isEmpty()) {
            if (this.isWriteFinalLinebreak()) {
                this.writeNewLine(writer);
            }
        } else {
            ElementLevel elementLevel = (ElementLevel)this.openTags.peek();
            if (!this.getTagDescription().hasCData(elementLevel.getNamespace(), elementLevel.getTagName())) {
                this.writeNewLine(writer);
            }
        }
    }

    private void buildAttributeName(AttributeList.AttributeEntry attributeEntry, DeclaredNamespaces declaredNamespaces, Writer writer) throws IOException {
        ElementLevel elementLevel = (ElementLevel)this.openTags.peek();
        String string = attributeEntry.getName();
        String string2 = attributeEntry.getNamespace();
        if (!this.isAlwaysAddNamespace() && ObjectUtilities.equal((Object)elementLevel.getNamespace(), (Object)string2)) {
            writer.write(string);
            return;
        }
        if (string2 == null) {
            writer.write(string);
            return;
        }
        if ("http://www.w3.org/2000/xmlns/".equals(string2)) {
            if ("".equals(string)) {
                writer.write("xmlns");
                return;
            }
            writer.write("xmlns:");
            writer.write(string);
            return;
        }
        String string3 = declaredNamespaces.getPrefix(string2);
        if (string3 != null && !"".equals(string3)) {
            writer.write(string3);
            writer.write(58);
            writer.write(string);
        } else {
            writer.write(string);
        }
    }

    public String normalizeLocal(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        this.normalizeBuffer.delete(0, this.normalizeBuffer.length());
        int n = string.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this.normalizeBuffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    this.normalizeBuffer.append("&gt;");
                    continue block8;
                }
                case '&': {
                    this.normalizeBuffer.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    this.normalizeBuffer.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    if (bl) {
                        this.normalizeBuffer.append("&#x000a;");
                        continue block8;
                    }
                    this.normalizeBuffer.append('\n');
                    continue block8;
                }
                case '\r': {
                    if (bl) {
                        this.normalizeBuffer.append("&#x000d;");
                        continue block8;
                    }
                    this.normalizeBuffer.append('\r');
                    continue block8;
                }
                default: {
                    this.normalizeBuffer.append(c);
                }
            }
        }
        String string2 = this.normalizeBuffer.toString();
        this.normalizeBuffer.delete(0, this.normalizeBuffer.length());
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeTextNormalized(Writer writer, String string, boolean bl) throws IOException {
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        block8: for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            switch (c) {
                case '<': {
                    if (n3 != 0) {
                        writer.write(cArray, n2, n3);
                        n3 = 0;
                    }
                    writer.write("&lt;");
                    n2 = i + 1;
                    continue block8;
                }
                case '>': {
                    if (n3 != 0) {
                        writer.write(cArray, n2, n3);
                        n3 = 0;
                    }
                    writer.write("&gt;");
                    n2 = i + 1;
                    continue block8;
                }
                case '&': {
                    if (n3 != 0) {
                        writer.write(cArray, n2, n3);
                        n3 = 0;
                    }
                    writer.write("&amp;");
                    n2 = i + 1;
                    continue block8;
                }
                case '\"': {
                    if (n3 != 0) {
                        writer.write(cArray, n2, n3);
                        n3 = 0;
                    }
                    writer.write("&quot;");
                    n2 = i + 1;
                    continue block8;
                }
                case '\n': {
                    if (!bl) break;
                    if (n3 != 0) {
                        writer.write(cArray, n2, n3);
                        n3 = 0;
                    }
                    writer.write("&#x000a;");
                    n2 = i + 1;
                    continue block8;
                }
                case '\r': {
                    if (!bl) break;
                    if (n3 != 0) {
                        writer.write(cArray, n2, n3);
                        n3 = 0;
                    }
                    writer.write("&#x000d;");
                    n2 = i + 1;
                    continue block8;
                }
            }
            ++n3;
        }
        if (n3 != 0) {
            writer.write(cArray, n2, n3);
        }
    }

    public static String normalize(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block8;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    if (bl) {
                        stringBuffer.append("&#x000a;");
                        continue block8;
                    }
                    stringBuffer.append('\n');
                    continue block8;
                }
                case '\r': {
                    if (bl) {
                        stringBuffer.append("&#x000d;");
                        continue block8;
                    }
                    stringBuffer.append('\r');
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void indent(Writer writer) throws IOException {
        if (this.openTags.isEmpty()) {
            for (int i = 0; i < this.additionalIndent; ++i) {
                writer.write(this.indentString);
            }
            return;
        }
        ElementLevel elementLevel = (ElementLevel)this.openTags.peek();
        if (!this.getTagDescription().hasCData(elementLevel.getNamespace(), elementLevel.getTagName())) {
            int n;
            this.doEndOfLine(writer);
            for (n = 0; n < this.openTags.size(); ++n) {
                writer.write(this.indentString);
            }
            for (n = 0; n < this.additionalIndent; ++n) {
                writer.write(this.indentString);
            }
        }
    }

    public void indentForClose(Writer writer) throws IOException {
        if (this.openTags.isEmpty()) {
            for (int i = 0; i < this.additionalIndent; ++i) {
                writer.write(this.indentString);
            }
            return;
        }
        ElementLevel elementLevel = (ElementLevel)this.openTags.peek();
        if (!this.getTagDescription().hasCData(elementLevel.getNamespace(), elementLevel.getTagName())) {
            int n;
            this.doEndOfLine(writer);
            for (n = 1; n < this.openTags.size(); ++n) {
                writer.write(this.indentString);
            }
            for (n = 0; n < this.additionalIndent; ++n) {
                writer.write(this.indentString);
            }
        }
    }

    public TagDescription getTagDescription() {
        return this.safeTags;
    }

    public void writeComment(Writer writer, String string) throws IOException {
        if (!this.openTags.isEmpty()) {
            ElementLevel elementLevel = (ElementLevel)this.openTags.peek();
            if (!this.getTagDescription().hasCData(elementLevel.getNamespace(), elementLevel.getTagName())) {
                this.indent(writer);
            }
        }
        this.setLineEmpty(false);
        writer.write("<!-- ");
        this.writeTextNormalized(writer, string, false);
        writer.write(" -->");
        this.doEndOfLine(writer);
    }

    public boolean isAssumeDefaultNamespace() {
        return this.assumeDefaultNamespace;
    }

    public void setAssumeDefaultNamespace(boolean bl) {
        this.assumeDefaultNamespace = bl;
    }

    public int getCurrentIndentLevel() {
        return this.additionalIndent + this.openTags.size();
    }

    public void setWriteFinalLinebreak(boolean bl) {
        this.writeFinalLinebreak = bl;
    }

    public boolean isWriteFinalLinebreak() {
        return this.writeFinalLinebreak;
    }

    private static class ElementLevel {
        private String namespace;
        private String prefix;
        private String tagName;
        private DeclaredNamespaces namespaces;

        protected ElementLevel(String string, String string2, String string3, DeclaredNamespaces declaredNamespaces) {
            if (string3 == null) {
                throw new NullPointerException();
            }
            if (declaredNamespaces == null) {
                throw new NullPointerException();
            }
            this.prefix = string2;
            this.namespace = string;
            this.tagName = string3;
            this.namespaces = declaredNamespaces;
        }

        protected ElementLevel(String string, DeclaredNamespaces declaredNamespaces) {
            if (string == null) {
                throw new NullPointerException();
            }
            if (declaredNamespaces == null) {
                throw new NullPointerException();
            }
            this.namespaces = declaredNamespaces;
            this.tagName = string;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getTagName() {
            return this.tagName;
        }

        public DeclaredNamespaces getNamespaces() {
            return this.namespaces;
        }
    }
}

